
package org.glassfish.jersey.jettison.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.jettison.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableERROR_WRITING_JSON_ARRAY() {
        return messageFactory.getMessage("error.writing.json.array");
    }

    /**
     * Error writing JSON array.
     * 
     */
    public static String ERROR_WRITING_JSON_ARRAY() {
        return localizer.localize(localizableERROR_WRITING_JSON_ARRAY());
    }

    public static Localizable localizableERROR_WRITING_JSON_OBJECT() {
        return messageFactory.getMessage("error.writing.json.object");
    }

    /**
     * Error writing JSON object.
     * 
     */
    public static String ERROR_WRITING_JSON_OBJECT() {
        return localizer.localize(localizableERROR_WRITING_JSON_OBJECT());
    }

    public static Localizable localizableERROR_PARSING_JSON_ARRAY() {
        return messageFactory.getMessage("error.parsing.json.array");
    }

    /**
     * Error parsing JSON array.
     * 
     */
    public static String ERROR_PARSING_JSON_ARRAY() {
        return localizer.localize(localizableERROR_PARSING_JSON_ARRAY());
    }

    public static Localizable localizableERROR_PARSING_JSON_OBJECT() {
        return messageFactory.getMessage("error.parsing.json.object");
    }

    /**
     * Error parsing JSON object.
     * 
     */
    public static String ERROR_PARSING_JSON_OBJECT() {
        return localizer.localize(localizableERROR_PARSING_JSON_OBJECT());
    }

}
