/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.json.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamReader;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.glassfish.jersey.media.json.JsonConfiguration;
import org.glassfish.jersey.media.json.internal.reader.Jackson2StaxReader;
import org.glassfish.jersey.media.json.internal.reader.JacksonRootAddingParser;
import org.glassfish.jersey.media.json.internal.reader.JsonXmlStreamReader;
import org.glassfish.jersey.media.json.internal.writer.JacksonArrayWrapperGenerator;
import org.glassfish.jersey.media.json.internal.writer.JacksonRootStrippingGenerator;
import org.glassfish.jersey.media.json.internal.writer.JsonXmlStreamWriter;
import org.glassfish.jersey.media.json.internal.writer.Stax2JacksonWriter;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class Stax2JsonFactory {
    private Stax2JsonFactory() {
    }

    public static XMLStreamWriter createWriter(Writer writer, JsonConfiguration config) throws IOException {
        return Stax2JsonFactory.createWriter(writer, config, false);
    }

    public static XMLStreamWriter createWriter(Writer writer, JsonConfiguration config, boolean writingList) throws IOException {
        switch (config.getNotation()) {
            case NATURAL: {
                JsonGenerator bodyGenerator;
                JsonGenerator rawGenerator = new JsonFactory().createJsonGenerator(writer);
                if (config.isHumanReadableFormatting()) {
                    rawGenerator.useDefaultPrettyPrinter();
                }
                JsonGenerator jsonGenerator = writingList ? JacksonArrayWrapperGenerator.createArrayWrapperGenerator(rawGenerator, config.isRootUnwrapping() ? 0 : 1) : (bodyGenerator = rawGenerator);
                if (config.isRootUnwrapping()) {
                    return new Stax2JacksonWriter(JacksonRootStrippingGenerator.createRootStrippingGenerator(bodyGenerator, writingList ? 2 : 1), config);
                }
                return new Stax2JacksonWriter(bodyGenerator, config);
            }
            case MAPPED: {
                return JsonXmlStreamWriter.createWriter(writer, config);
            }
            case BADGERFISH: {
                return new BadgerFishXMLStreamWriter(writer);
            }
            case MAPPED_JETTISON: {
                Configuration jmConfig = null == config.getXml2JsonNs() ? new Configuration() : new Configuration(config.getXml2JsonNs());
                return new MappedXMLStreamWriter(new MappedNamespaceConvention(jmConfig), writer);
            }
        }
        return null;
    }

    public static XMLStreamReader createReader(Reader reader, JsonConfiguration config, String rootName) throws XMLStreamException {
        return Stax2JsonFactory.createReader(reader, config, rootName, false);
    }

    public static XMLStreamReader createReader(Reader reader, JsonConfiguration config, String rootName, boolean readingList) throws XMLStreamException {
        Reader nonEmptyReader = Stax2JsonFactory.ensureNonEmptyReader(reader);
        switch (config.getNotation()) {
            case NATURAL: {
                try {
                    JsonParser nonListParser;
                    JsonParser rawParser = new JsonFactory().createJsonParser(nonEmptyReader);
                    JsonParser jsonParser = nonListParser = config.isRootUnwrapping() ? JacksonRootAddingParser.createRootAddingParser(rawParser, rootName) : rawParser;
                    if (!readingList) {
                        return new Jackson2StaxReader(nonListParser, config);
                    }
                    return new Jackson2StaxReader(JacksonRootAddingParser.createRootAddingParser(nonListParser, "jsonArrayRootElement"), config);
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }
            case MAPPED: {
                try {
                    return new JsonXmlStreamReader(nonEmptyReader, rootName, config);
                }
                catch (IOException ex) {
                    throw new XMLStreamException(ex);
                }
            }
            case MAPPED_JETTISON: {
                try {
                    Configuration jmConfig = null == config.getXml2JsonNs() ? new Configuration() : new Configuration(config.getXml2JsonNs());
                    return new MappedXMLStreamReader(new JSONObject(new JSONTokener(ReaderWriter.readFromAsString((Reader)nonEmptyReader))), new MappedNamespaceConvention(jmConfig));
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }
            case BADGERFISH: {
                try {
                    return new BadgerFishXMLStreamReader(new JSONObject(new JSONTokener(ReaderWriter.readFromAsString((Reader)nonEmptyReader))));
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }
        }
        throw new IllegalArgumentException("Unknown JSON config");
    }

    private static Reader ensureNonEmptyReader(Reader reader) throws XMLStreamException {
        try {
            Reader mr = reader.markSupported() ? reader : new BufferedReader(reader);
            mr.mark(1);
            if (mr.read() == -1) {
                throw new XMLStreamException("JSON expression can not be empty!");
            }
            mr.reset();
            return mr;
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }
}

