/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.json.internal.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.jersey.media.json.JsonConfiguration;
import org.glassfish.jersey.media.json.JsonConfigured;
import org.glassfish.jersey.media.json.internal.JsonHelper;
import org.glassfish.jersey.media.json.internal.Stax2JsonFactory;
import org.glassfish.jersey.message.internal.AbstractCollectionJaxbProvider;

public class JsonListElementProvider
extends AbstractCollectionJaxbProvider {
    boolean jacksonEntityProviderTakesPrecedence = false;

    JsonListElementProvider(Providers ps) {
        super(ps);
    }

    JsonListElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.jacksonEntityProviderTakesPrecedence && super.isReadable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.jacksonEntityProviderTakesPrecedence && super.isWriteable(type, genericType, annotations, mediaType);
    }

    public final void writeList(Class<?> elementType, Collection<?> t, MediaType mediaType, Charset c, Marshaller m, OutputStream entityStream) throws JAXBException, IOException {
        OutputStreamWriter osw = new OutputStreamWriter(entityStream, c);
        JsonConfiguration origJsonConfig = JsonConfiguration.DEFAULT;
        if (m instanceof JsonConfigured) {
            origJsonConfig = ((JsonConfigured)m).getJSONConfiguration();
        }
        JsonConfiguration unwrappingJsonConfig = JsonConfiguration.createJSONConfigurationWithRootUnwrapping(origJsonConfig, true);
        XMLStreamWriter jxsw = Stax2JsonFactory.createWriter(osw, unwrappingJsonConfig, true);
        String invisibleRootName = this.getRootElementName(elementType);
        String elementName = this.getElementName(elementType);
        try {
            if (!origJsonConfig.isRootUnwrapping()) {
                osw.append(String.format("{\"%s\":", elementName));
                osw.flush();
            }
            jxsw.writeStartDocument();
            jxsw.writeStartElement(invisibleRootName);
            for (Object o : t) {
                m.marshal(o, jxsw);
            }
            jxsw.writeEndElement();
            jxsw.writeEndDocument();
            jxsw.flush();
            if (!origJsonConfig.isRootUnwrapping()) {
                osw.append("}");
                osw.flush();
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(JsonListElementProvider.class.getName()).log(Level.SEVERE, null, ex);
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected final XMLStreamReader getXMLStreamReader(Class<?> elementType, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws XMLStreamException {
        JsonConfiguration c = JsonConfiguration.DEFAULT;
        Charset charset = JsonListElementProvider.getCharset((MediaType)mediaType);
        if (u instanceof JsonConfigured) {
            c = ((JsonConfigured)u).getJSONConfiguration();
        }
        return Stax2JsonFactory.createReader(new InputStreamReader(entityStream, charset), c, JsonHelper.getRootElementName(elementType), true);
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JsonListElementProvider {
        public General(@Context Providers ps) {
            super(ps);
        }

        protected boolean isSupported(MediaType m) {
            return !this.jacksonEntityProviderTakesPrecedence && m.getSubtype().endsWith("+json");
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JsonListElementProvider {
        public App(@Context Providers ps) {
            super(ps, MediaType.APPLICATION_JSON_TYPE);
        }
    }
}

