/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.json.internal.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.media.json.JsonWithPadding;
import org.glassfish.jersey.media.json.internal.LocalizationMessages;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.jvnet.hk2.annotations.Inject;

@Produces(value={"application/javascript", "application/x-javascript", "application/ecmascript", "application/json", "text/jscript", "text/ecmascript"})
public class JsonWithPaddingProvider
extends AbstractMessageReaderWriterProvider<JsonWithPadding> {
    private static final Logger LOGGER = Logger.getLogger(JsonWithPaddingProvider.class.getName());
    private final Map<String, Set<String>> javascriptTypes = new HashMap<String, Set<String>>();
    @Inject
    Factory<MessageBodyWorkers> bodyWorker;

    public JsonWithPaddingProvider() {
        this.javascriptTypes.put("application", new HashSet<String>(Arrays.asList("x-javascript", "ecmascript", "javascript")));
        this.javascriptTypes.put("text", new HashSet<String>(Arrays.asList("ecmascript", "jscript")));
    }

    private boolean isJavascript(MediaType m) {
        Set<String> subtypes = this.javascriptTypes.get(m.getType());
        if (subtypes == null) {
            return false;
        }
        return subtypes.contains(m.getSubtype());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return false;
    }

    public JsonWithPadding readFrom(Class<JsonWithPadding> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        throw new UnsupportedOperationException("Not supported by design.");
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == JsonWithPadding.class;
    }

    public void writeTo(JsonWithPadding t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        boolean isJavaScript;
        Object jsonEntity = t.getJsonSource();
        Type entityGenericType = jsonEntity.getClass();
        Class entityType = jsonEntity.getClass();
        boolean genericEntityUsed = jsonEntity instanceof GenericEntity;
        if (genericEntityUsed) {
            GenericEntity ge = (GenericEntity)jsonEntity;
            jsonEntity = ge.getEntity();
            entityGenericType = ge.getType();
            entityType = ge.getRawType();
        }
        MediaType workerMediaType = (isJavaScript = this.isJavascript(mediaType)) ? MediaType.APPLICATION_JSON_TYPE : mediaType;
        MessageBodyWriter bw = ((MessageBodyWorkers)this.bodyWorker.get()).getMessageBodyWriter(entityType, entityGenericType, annotations, workerMediaType);
        if (bw == null) {
            if (!genericEntityUsed) {
                LOGGER.severe(LocalizationMessages.ERROR_NONGE_JSONP_MSG_BODY_WRITER_NOT_FOUND(jsonEntity, workerMediaType));
            } else {
                LOGGER.severe(LocalizationMessages.ERROR_JSONP_MSG_BODY_WRITER_NOT_FOUND(jsonEntity, workerMediaType));
            }
            throw new WebApplicationException(500);
        }
        if (isJavaScript) {
            entityStream.write(t.getCallbackName().getBytes());
            entityStream.write(40);
        }
        bw.writeTo(jsonEntity, entityType, entityGenericType, annotations, workerMediaType, httpHeaders, entityStream);
        if (isJavaScript) {
            entityStream.write(41);
        }
    }
}

