/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.kryo.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;

@Provider
@Consumes(value={"application/x-kryo"})
@Produces(value={"application/x-kryo"})
public class KryoMessageBodyProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private final ContextResolver<Kryo> contextResolver;
    private final Optional<KryoPool> kryoPool;

    public KryoMessageBodyProvider(@Context Providers providers) {
        MediaType mediaType = new MediaType("application", "x-kryo");
        this.contextResolver = providers.getContextResolver(Kryo.class, mediaType);
        this.kryoPool = this.getKryoPool();
    }

    private Kryo getKryo() {
        return this.contextResolver != null ? (Kryo)this.contextResolver.getContext(null) : null;
    }

    private Optional<KryoPool> getKryoPool() {
        final Kryo kryo = this.getKryo();
        KryoFactory kryoFactory = new KryoFactory(){

            public Kryo create() {
                return kryo;
            }
        };
        return kryo == null ? Optional.empty() : Optional.of(new KryoPool.Builder(kryoFactory).softReferences().build());
    }

    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.kryoPool != null;
    }

    public void writeTo(final Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        final Output output = new Output(entityStream);
        this.kryoPool.ifPresent(a -> a.run(new KryoCallback(){

            public Object execute(Kryo kryo) {
                kryo.writeObject(output, object);
                return null;
            }
        }));
        output.flush();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.kryoPool != null;
    }

    public Object readFrom(final Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        final Input input = new Input(entityStream);
        return this.kryoPool.map(pool -> pool.run(new KryoCallback(){

            public Object execute(Kryo kryo) {
                return kryo.readObject(input, type);
            }
        })).orElse(null);
    }
}

