/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.json.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import jersey.repackaged.com.google.common.collect.Maps;
import jersey.repackaged.com.google.common.collect.Sets;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.jaxb.MarshallerProperties;
import org.eclipse.persistence.jaxb.UnmarshallerProperties;
import org.eclipse.persistence.jaxb.rs.MOXyJsonProvider;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.moxy.json.MoxyJsonConfig;

@Singleton
public class ConfigurableMoxyJsonProvider
extends MOXyJsonProvider {
    private static final Set<String> MARSHALLER_PROPERTY_NAMES = ConfigurableMoxyJsonProvider.getPropertyNames(MarshallerProperties.class);
    private static final Set<String> UNMARSHALLER_PROPERTY_NAMES = ConfigurableMoxyJsonProvider.getPropertyNames(UnmarshallerProperties.class);
    @Context
    private Providers providers;
    @Context
    private Configuration config;
    private MoxyJsonConfig globalConfig;

    private static Set<String> getPropertyNames(Class<?> propertiesClass) {
        HashSet propertyNames = Sets.newHashSet();
        for (Field field : (Field[])AccessController.doPrivileged(ReflectionHelper.getDeclaredFieldsPA(propertiesClass))) {
            if (String.class != field.getType() || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                propertyNames.add((String)field.get(null));
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return propertyNames;
    }

    private MoxyJsonConfig getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = new MoxyJsonConfig().setMarshallerProperties(this.getConfigProperties(this.config, MARSHALLER_PROPERTY_NAMES)).setUnmarshallerProperties(this.getConfigProperties(this.config, UNMARSHALLER_PROPERTY_NAMES));
        }
        return this.globalConfig;
    }

    private Map<String, Object> getConfigProperties(Configuration config, Set<String> propertyNames) {
        HashMap properties = Maps.newHashMap();
        for (String propertyName : propertyNames) {
            Object property = config.getProperty(propertyName);
            if (property == null) continue;
            properties.put(propertyName, property);
        }
        return properties;
    }

    protected void preReadFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, Unmarshaller unmarshaller) throws JAXBException {
        super.preReadFrom(type, genericType, annotations, mediaType, httpHeaders, unmarshaller);
        this.initializeUnmarshaller(unmarshaller);
    }

    protected void preWriteTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, Marshaller marshaller) throws JAXBException {
        super.preWriteTo(object, type, genericType, annotations, mediaType, httpHeaders, marshaller);
        this.initializeMarshaller(marshaller);
    }

    private void initializeUnmarshaller(Unmarshaller unmarshaller) throws PropertyException {
        for (Map.Entry<String, Object> property : this.getProperties(false).entrySet()) {
            unmarshaller.setProperty(property.getKey(), property.getValue());
        }
    }

    private void initializeMarshaller(Marshaller marshaller) throws PropertyException {
        for (Map.Entry<String, Object> property : this.getProperties(true).entrySet()) {
            marshaller.setProperty(property.getKey(), property.getValue());
        }
    }

    private Map<String, Object> getProperties(boolean forMarshaller) {
        MoxyJsonConfig jsonConfiguration;
        HashMap properties = Maps.newHashMap(forMarshaller ? this.getGlobalConfig().getMarshallerProperties() : this.getGlobalConfig().getUnmarshallerProperties());
        ContextResolver contextResolver = this.providers.getContextResolver(MoxyJsonConfig.class, MediaType.APPLICATION_JSON_TYPE);
        if (contextResolver != null && (jsonConfiguration = (MoxyJsonConfig)contextResolver.getContext(MoxyJsonConfig.class)) != null) {
            properties.putAll(forMarshaller ? jsonConfiguration.getMarshallerProperties() : jsonConfiguration.getUnmarshallerProperties());
        }
        return properties;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.isPrimitiveType(type) && !Map.class.isAssignableFrom(type) && super.isReadable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.isPrimitiveType(type) && !Map.class.isAssignableFrom(type) && super.isWriteable(type, genericType, annotations, mediaType);
    }

    private boolean isPrimitiveType(Class<?> type) {
        return CoreClassConstants.STRING == type || CoreClassConstants.PCHAR == type || CoreClassConstants.CHAR == type || CoreClassConstants.PSHORT == type || CoreClassConstants.SHORT == type || CoreClassConstants.PINT == type || CoreClassConstants.INTEGER == type || CoreClassConstants.PLONG == type || CoreClassConstants.LONG == type || CoreClassConstants.PFLOAT == type || CoreClassConstants.FLOAT == type || CoreClassConstants.PDOUBLE == type || CoreClassConstants.DOUBLE == type || CoreClassConstants.PBOOLEAN == type || CoreClassConstants.BOOLEAN == type || CoreClassConstants.PBYTE == type || CoreClassConstants.BYTE == type;
    }
}

