/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart;

import java.text.ParseException;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.message.internal.ContentDisposition;
import org.glassfish.jersey.message.internal.FormDataContentDisposition;
import org.glassfish.jersey.message.internal.MediaTypes;

public class FormDataBodyPart
extends BodyPart {
    public FormDataBodyPart() {
    }

    public FormDataBodyPart(MediaType mediaType) {
        super(mediaType);
    }

    public FormDataBodyPart(Object entity, MediaType mediaType) {
        super(entity, mediaType);
    }

    public FormDataBodyPart(String name, String value) {
        super(value, MediaType.TEXT_PLAIN_TYPE);
        this.setName(name);
    }

    public FormDataBodyPart(String name, Object entity, MediaType mediaType) {
        super(entity, mediaType);
        this.setName(name);
    }

    public FormDataBodyPart(FormDataContentDisposition formDataContentDisposition, String value) {
        super(value, MediaType.TEXT_PLAIN_TYPE);
        this.setFormDataContentDisposition(formDataContentDisposition);
    }

    public FormDataBodyPart(FormDataContentDisposition formDataContentDisposition, Object entity, MediaType mediaType) {
        super(entity, mediaType);
        this.setFormDataContentDisposition(formDataContentDisposition);
    }

    public FormDataContentDisposition getFormDataContentDisposition() {
        return (FormDataContentDisposition)this.getContentDisposition();
    }

    public void setFormDataContentDisposition(FormDataContentDisposition formDataContentDisposition) {
        super.setContentDisposition((ContentDisposition)formDataContentDisposition);
    }

    @Override
    public ContentDisposition getContentDisposition() {
        String scd;
        if (this.contentDisposition == null && (scd = (String)this.getHeaders().getFirst((Object)"Content-Disposition")) != null) {
            try {
                this.contentDisposition = new FormDataContentDisposition(scd);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Error parsing content disposition: " + scd, ex);
            }
        }
        return this.contentDisposition;
    }

    @Override
    public void setContentDisposition(ContentDisposition contentDisposition) {
        if (!(contentDisposition instanceof FormDataContentDisposition)) {
            throw new IllegalArgumentException();
        }
        super.setContentDisposition(contentDisposition);
    }

    public String getName() {
        FormDataContentDisposition formDataContentDisposition = this.getFormDataContentDisposition();
        if (formDataContentDisposition == null) {
            return null;
        }
        return formDataContentDisposition.getName();
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null.");
        }
        if (this.getFormDataContentDisposition() == null) {
            FormDataContentDisposition contentDisposition = FormDataContentDisposition.name((String)name).build();
            super.setContentDisposition((ContentDisposition)contentDisposition);
        } else {
            FormDataContentDisposition formDataContentDisposition = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)name).fileName(this.contentDisposition.getFileName())).creationDate(this.contentDisposition.getCreationDate())).modificationDate(this.contentDisposition.getModificationDate())).readDate(this.contentDisposition.getReadDate())).size(this.contentDisposition.getSize())).build();
            super.setContentDisposition((ContentDisposition)formDataContentDisposition);
        }
    }

    public String getValue() {
        if (!MediaTypes.typeEqual((MediaType)MediaType.TEXT_PLAIN_TYPE, (MediaType)this.getMediaType())) {
            throw new IllegalStateException("Media type is not text/plain");
        }
        if (this.getEntity() instanceof BodyPartEntity) {
            return this.getEntityAs(String.class);
        }
        return (String)this.getEntity();
    }

    public <T> T getValueAs(Class<T> clazz) {
        return this.getEntityAs(clazz);
    }

    public void setValue(String value) {
        if (!MediaType.TEXT_PLAIN_TYPE.equals((Object)this.getMediaType())) {
            throw new IllegalStateException("Media type is not text/plain");
        }
        this.setEntity(value);
    }

    public void setValue(MediaType mediaType, Object value) {
        this.setMediaType(mediaType);
        this.setEntity(value);
    }

    public boolean isSimple() {
        return MediaType.TEXT_PLAIN_TYPE.equals((Object)this.getMediaType());
    }
}

