/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartProperties;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.mimepull.Header;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEParsingException;
import org.jvnet.mimepull.MIMEPart;

@Consumes(value={"multipart/*"})
public class MultiPartReaderClientSide
implements MessageBodyReader<MultiPart> {
    private final MultiPartProperties config;
    @Inject
    private Ref<MessageBodyWorkers> messageBodyWorkers;
    private final MIMEConfig mimeConfig;

    public MultiPartReaderClientSide(@Context MultiPartProperties config) {
        if (config == null) {
            throw new IllegalArgumentException("The MultiPartConfig instance we expected is not present.Have you registered the MultiPartConfigProvider class?");
        }
        this.config = config;
        this.mimeConfig = new MIMEConfig();
        this.mimeConfig.setMemoryThreshold((long)config.getBufferThreshold());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    public MultiPart readFrom(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, WebApplicationException {
        try {
            return this.readMultiPart(type, genericType, annotations, mediaType, headers, stream);
        }
        catch (MIMEParsingException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }

    protected MultiPart readMultiPart(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, MIMEParsingException {
        MIMEMessage mimeMessage = new MIMEMessage(stream, (String)mediaType.getParameters().get("boundary"), this.mimeConfig);
        boolean formData = false;
        MultiPart multiPart = null;
        if (MediaTypes.typeEqual((MediaType)mediaType, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE)) {
            multiPart = new FormDataMultiPart();
            formData = true;
        } else {
            multiPart = new MultiPart();
        }
        multiPart.setMessageBodyWorkers((MessageBodyWorkers)this.messageBodyWorkers.get());
        MultivaluedMap<String, String> multiPartHeaders = multiPart.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                multiPartHeaders.add(entry.getKey(), (Object)value);
            }
        }
        if (!formData) {
            multiPart.setMediaType(mediaType);
        }
        for (MIMEPart mimePart : mimeMessage.getAttachments()) {
            BodyPart bodyPart = formData ? new FormDataBodyPart() : new BodyPart();
            bodyPart.setMessageBodyWorkers((MessageBodyWorkers)this.messageBodyWorkers.get());
            for (Header header : mimePart.getAllHeaders()) {
                bodyPart.getHeaders().add((Object)header.getName(), (Object)header.getValue());
            }
            try {
                String contentType = (String)bodyPart.getHeaders().getFirst((Object)"Content-Type");
                if (contentType != null) {
                    bodyPart.setMediaType(MediaType.valueOf((String)contentType));
                }
                bodyPart.getContentDisposition();
            }
            catch (IllegalArgumentException ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
            }
            bodyPart.setEntity(new BodyPartEntity(mimePart));
            multiPart.getBodyParts().add(bodyPart);
        }
        return multiPart;
    }
}

