/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public final class FormDataParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    private static final Set<Class<?>> types = FormDataParamValueFactoryProvider.initializeTypes();

    private static Set<Class<?>> initializeTypes() {
        HashSet newSet = new HashSet();
        newSet.add(Byte.class);
        newSet.add(Byte.TYPE);
        newSet.add(Short.class);
        newSet.add(Short.TYPE);
        newSet.add(Integer.class);
        newSet.add(Integer.TYPE);
        newSet.add(Long.class);
        newSet.add(Long.TYPE);
        newSet.add(Float.class);
        newSet.add(Float.TYPE);
        newSet.add(Double.class);
        newSet.add(Double.TYPE);
        newSet.add(Boolean.class);
        newSet.add(Boolean.TYPE);
        newSet.add(Character.class);
        newSet.add(Character.TYPE);
        return newSet;
    }

    private static boolean isPrimitiveType(Class<?> type) {
        return types.contains(type);
    }

    @Inject
    public FormDataParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator) {
        super(mpep, locator, new Parameter.Source[]{Parameter.Source.ENTITY, Parameter.Source.UNKNOWN});
    }

    protected Factory<?> createValueFactory(Parameter parameter) {
        Class parameterRawType = parameter.getRawType();
        if (Parameter.Source.ENTITY == parameter.getSource()) {
            if (FormDataMultiPart.class.isAssignableFrom(parameterRawType)) {
                return new FormDataMultiPartValueFactory();
            }
            return null;
        }
        if (parameter.getAnnotation().annotationType() == FormDataParam.class) {
            String parameterName = parameter.getSourceName();
            if (parameterName == null || parameterName.length() == 0) {
                return null;
            }
            MultivaluedParameterExtractor extractor = this.get(parameter);
            if (Collection.class == parameterRawType || List.class == parameterRawType) {
                Class c = (Class)ReflectionHelper.getGenericTypeArgumentClasses((Type)parameter.getType()).get(0);
                if (FormDataBodyPart.class == c) {
                    return new ListFormDataBodyPartValueFactory(parameter.getSourceName());
                }
                if (FormDataContentDisposition.class == c) {
                    return new ListFormDataContentDispositionValueFactory(parameter.getSourceName());
                }
            } else {
                if (FormDataBodyPart.class == parameterRawType) {
                    return new FormDataBodyPartValueFactory(parameter.getSourceName());
                }
                if (FormDataContentDisposition.class == parameterRawType) {
                    return new FormDataContentDispositionMultiPartInjectable(parameter.getSourceName());
                }
                return new FormDataParamValueFactory(parameter, extractor);
            }
        }
        return null;
    }

    private FormDataMultiPart getEntity(HttpContext context) {
        ContainerRequest requestContext = context.getRequestContext();
        if (requestContext.getProperty(FormDataMultiPart.class.getName()) == null) {
            FormDataMultiPart formDataMultiPart = (FormDataMultiPart)requestContext.readEntity(FormDataMultiPart.class);
            requestContext.setProperty(FormDataMultiPart.class.getName(), (Object)formDataMultiPart);
        }
        return (FormDataMultiPart)requestContext.getProperty(FormDataMultiPart.class.getName());
    }

    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.HIGH;
    }

    private final class FormDataMultiPartValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private FormDataMultiPartValueFactory() {
        }

        protected Object get(HttpContext context) {
            return FormDataParamValueFactoryProvider.this.getEntity(context);
        }
    }

    private final class FormDataParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final Parameter parameter;

        public FormDataParamValueFactory(Parameter parameter, MultivaluedParameterExtractor<?> extractor) {
            this.parameter = parameter;
            this.extractor = extractor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Object get(HttpContext context) {
            FormDataMultiPart formDataMultiPart = FormDataParamValueFactoryProvider.this.getEntity(context);
            List<FormDataBodyPart> formDataBodyParts = formDataMultiPart.getFields(this.parameter.getSourceName());
            FormDataBodyPart formDataBodyPart = formDataBodyParts != null ? formDataBodyParts.get(0) : null;
            MediaType mediaType = formDataBodyPart != null ? formDataBodyPart.getMediaType() : MediaType.TEXT_PLAIN_TYPE;
            MessageBodyWorkers messageBodyWorkers = context.getRequestContext().getWorkers();
            MessageBodyReader reader = messageBodyWorkers.getMessageBodyReader(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType);
            if (reader != null && !FormDataParamValueFactoryProvider.isPrimitiveType(this.parameter.getRawType())) {
                InputStream in;
                if (formDataBodyPart == null) {
                    if (this.parameter.getDefaultValue() == null) return null;
                    in = new ByteArrayInputStream(this.parameter.getDefaultValue().getBytes());
                } else {
                    in = ((BodyPartEntity)formDataBodyPart.getEntity()).getInputStream();
                }
                try {
                    return reader.readFrom(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType, context.getRequestContext().getHeaders(), in);
                }
                catch (IOException e) {
                    throw new FormDataParamException(e, this.extractor.getName(), this.extractor.getDefaultValueString());
                }
            }
            if (this.extractor == null) return null;
            MultivaluedStringMap map = new MultivaluedStringMap();
            if (formDataBodyPart == null) return this.extractor.extract((MultivaluedMap)map);
            try {
                for (FormDataBodyPart p : formDataBodyParts) {
                    mediaType = p.getMediaType();
                    reader = messageBodyWorkers.getMessageBodyReader(String.class, String.class, this.parameter.getAnnotations(), mediaType);
                    String value = (String)reader.readFrom(String.class, String.class, this.parameter.getAnnotations(), mediaType, context.getRequestContext().getHeaders(), ((BodyPartEntity)p.getEntity()).getInputStream());
                    map.add((Object)this.parameter.getSourceName(), (Object)value);
                }
                return this.extractor.extract((MultivaluedMap)map);
            }
            catch (IOException e) {
                throw new FormDataParamException(e, this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    private final class FormDataContentDispositionMultiPartInjectable
    extends AbstractHttpContextValueFactory<FormDataContentDisposition> {
        private final String name;

        public FormDataContentDispositionMultiPartInjectable(String name) {
            this.name = name;
        }

        protected FormDataContentDisposition get(HttpContext context) {
            FormDataMultiPart formDataMultiPart = FormDataParamValueFactoryProvider.this.getEntity(context);
            FormDataBodyPart formDataBodyPart = formDataMultiPart.getField(this.name);
            if (formDataBodyPart == null) {
                return null;
            }
            return formDataMultiPart.getField(this.name).getFormDataContentDisposition();
        }
    }

    private final class FormDataBodyPartValueFactory
    extends AbstractHttpContextValueFactory<FormDataBodyPart> {
        private final String name;

        public FormDataBodyPartValueFactory(String name) {
            this.name = name;
        }

        protected FormDataBodyPart get(HttpContext context) {
            return FormDataParamValueFactoryProvider.this.getEntity(context).getField(this.name);
        }
    }

    private final class ListFormDataContentDispositionValueFactory
    extends AbstractHttpContextValueFactory<List<FormDataContentDisposition>> {
        private final String name;

        public ListFormDataContentDispositionValueFactory(String name) {
            this.name = name;
        }

        protected List<FormDataContentDisposition> get(HttpContext context) {
            FormDataMultiPart formDataMultiPart = FormDataParamValueFactoryProvider.this.getEntity(context);
            List<FormDataBodyPart> formDataBodyParts = formDataMultiPart.getFields(this.name);
            if (formDataBodyParts == null) {
                return null;
            }
            ArrayList<FormDataContentDisposition> list = new ArrayList<FormDataContentDisposition>(formDataBodyParts.size());
            for (FormDataBodyPart formDataBodyPart : formDataBodyParts) {
                list.add(formDataBodyPart.getFormDataContentDisposition());
            }
            return list;
        }
    }

    private final class ListFormDataBodyPartValueFactory
    extends AbstractHttpContextValueFactory<List<FormDataBodyPart>> {
        private final String name;

        public ListFormDataBodyPartValueFactory(String name) {
            this.name = name;
        }

        protected List<FormDataBodyPart> get(HttpContext context) {
            return FormDataParamValueFactoryProvider.this.getEntity(context).getFields(this.name);
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<FormDataParam> {
        public InjectionResolver() {
            super(FormDataParamValueFactoryProvider.class);
        }
    }

    private static final class FormDataParamException
    extends ParamException {
        protected FormDataParamException(Throwable cause, String name, String defaultStringValue) {
            super(cause, (Response.StatusType)Response.Status.BAD_REQUEST, FormDataParam.class, name, defaultStringValue);
        }
    }
}

