/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.FormDataParamException;
import org.glassfish.jersey.media.multipart.internal.LocalizationMessages;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.MessageUtils;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractRequestDerivedValueSupplier;
import org.glassfish.jersey.server.internal.inject.AbstractValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueSupplierProvider;
import org.jvnet.mimepull.MIMEParsingException;

final class FormDataParamValueSupplierProvider
extends AbstractValueSupplierProvider {
    private static final Logger LOGGER = Logger.getLogger(FormDataParamValueSupplierProvider.class.getName());
    private static final Set<Class<?>> TYPES = FormDataParamValueSupplierProvider.initializeTypes();

    private static Set<Class<?>> initializeTypes() {
        HashSet<Class<Serializable>> newSet = new HashSet<Class<Serializable>>();
        newSet.add(Byte.class);
        newSet.add(Byte.TYPE);
        newSet.add(Short.class);
        newSet.add(Short.TYPE);
        newSet.add(Integer.class);
        newSet.add(Integer.TYPE);
        newSet.add(Long.class);
        newSet.add(Long.TYPE);
        newSet.add(Float.class);
        newSet.add(Float.TYPE);
        newSet.add(Double.class);
        newSet.add(Double.TYPE);
        newSet.add(Boolean.class);
        newSet.add(Boolean.TYPE);
        newSet.add(Character.class);
        newSet.add(Character.TYPE);
        return Collections.unmodifiableSet(newSet);
    }

    private static boolean isPrimitiveType(Class<?> type) {
        return TYPES.contains(type);
    }

    public FormDataParamValueSupplierProvider(MultivaluedParameterExtractorProvider extractorProvider, Provider<ContainerRequest> requestProvider) {
        super(extractorProvider, requestProvider, new Parameter.Source[]{Parameter.Source.ENTITY, Parameter.Source.UNKNOWN});
    }

    protected AbstractRequestDerivedValueSupplier<?> createValueSupplier(Parameter parameter, Provider<ContainerRequest> requestProvider) {
        Class rawType = parameter.getRawType();
        if (Parameter.Source.ENTITY == parameter.getSource()) {
            if (FormDataMultiPart.class.isAssignableFrom(rawType)) {
                return new FormDataMultiPartSupplier(requestProvider);
            }
            return null;
        }
        if (parameter.getSourceAnnotation().annotationType() == FormDataParam.class) {
            String paramName = parameter.getSourceName();
            if (paramName == null || paramName.isEmpty()) {
                return null;
            }
            if (Collection.class == rawType || List.class == rawType) {
                Class clazz = (Class)ReflectionHelper.getGenericTypeArgumentClasses((Type)parameter.getType()).get(0);
                if (FormDataBodyPart.class == clazz) {
                    return new ListFormDataBodyPartValueSupplier(paramName, requestProvider);
                }
                if (FormDataContentDisposition.class == clazz) {
                    return new ListFormDataContentDispositionSupplier(paramName, requestProvider);
                }
                return new FormDataParamValueSupplier(parameter, this.get(parameter), requestProvider);
            }
            if (FormDataBodyPart.class == rawType) {
                return new FormDataBodyPartSupplier(paramName, requestProvider);
            }
            if (FormDataContentDisposition.class == rawType) {
                return new FormDataContentDispositionSupplier(paramName, requestProvider);
            }
            if (File.class == rawType) {
                return new FileSupplier(paramName, requestProvider);
            }
            return new FormDataParamValueSupplier(parameter, this.get(parameter), requestProvider);
        }
        return null;
    }

    public ValueSupplierProvider.PriorityType getPriority() {
        return ValueSupplierProvider.Priority.HIGH;
    }

    private final class FormDataParamValueSupplier
    extends ValueSupplier<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final Parameter parameter;

        public FormDataParamValueSupplier(Parameter parameter, MultivaluedParameterExtractor<?> extractor, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.parameter = parameter;
            this.extractor = extractor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object get() {
            List<FormDataBodyPart> parts = this.getEntity().getFields(this.parameter.getSourceName());
            FormDataBodyPart part = parts != null ? parts.get(0) : null;
            MediaType mediaType = part != null ? part.getMediaType() : MediaType.TEXT_PLAIN_TYPE;
            ContainerRequest request = this.getRequest();
            MessageBodyWorkers messageBodyWorkers = request.getWorkers();
            MessageBodyReader reader = messageBodyWorkers.getMessageBodyReader(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType);
            if (reader != null && !FormDataParamValueSupplierProvider.isPrimitiveType(this.parameter.getRawType())) {
                InputStream stream;
                if (part == null) {
                    if (this.parameter.getDefaultValue() == null) return null;
                    stream = new ByteArrayInputStream(this.parameter.getDefaultValue().getBytes(MessageUtils.getCharset((MediaType)mediaType)));
                } else {
                    stream = part.getEntityAs(BodyPartEntity.class).getInputStream();
                }
                try {
                    return reader.readFrom(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType, request.getHeaders(), stream);
                }
                catch (IOException e) {
                    throw new FormDataParamException(e, this.parameter.getSourceName(), this.parameter.getDefaultValue());
                }
            }
            if (this.extractor == null) return null;
            MultivaluedStringMap map = new MultivaluedStringMap();
            try {
                if (part == null) return this.extractor.extract((MultivaluedMap)map);
                for (FormDataBodyPart p : parts) {
                    reader = messageBodyWorkers.getMessageBodyReader(String.class, String.class, this.parameter.getAnnotations(), p.getMediaType());
                    String value = (String)reader.readFrom(String.class, String.class, this.parameter.getAnnotations(), mediaType, request.getHeaders(), ((BodyPartEntity)p.getEntity()).getInputStream());
                    map.add((Object)this.parameter.getSourceName(), (Object)value);
                }
                return this.extractor.extract((MultivaluedMap)map);
            }
            catch (IOException | ExtractorException ex) {
                throw new FormDataParamException(ex, this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    private final class FileSupplier
    extends ValueSupplier<File> {
        private final String name;

        public FileSupplier(String name, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.name = name;
        }

        public File get() {
            BodyPartEntity entity;
            FormDataBodyPart part = this.getEntity().getField(this.name);
            BodyPartEntity bodyPartEntity = entity = part != null ? part.getEntityAs(BodyPartEntity.class) : null;
            if (entity != null) {
                try {
                    File file = Utils.createTempFile();
                    entity.moveTo(file);
                    return file;
                }
                catch (IOException | MIMEParsingException cannotMove) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.CANNOT_INJECT_FILE(), cannotMove);
                }
            }
            return null;
        }
    }

    private final class FormDataContentDispositionSupplier
    extends ValueSupplier<FormDataContentDisposition> {
        private final String name;

        public FormDataContentDispositionSupplier(String name, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.name = name;
        }

        public FormDataContentDisposition get() {
            FormDataBodyPart part = this.getEntity().getField(this.name);
            return part == null ? null : part.getFormDataContentDisposition();
        }
    }

    private final class FormDataBodyPartSupplier
    extends ValueSupplier<FormDataBodyPart> {
        private final String name;

        public FormDataBodyPartSupplier(String name, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.name = name;
        }

        public FormDataBodyPart get() {
            return this.getEntity().getField(this.name);
        }
    }

    private final class ListFormDataContentDispositionSupplier
    extends ValueSupplier<List<FormDataContentDisposition>> {
        private final String name;

        public ListFormDataContentDispositionSupplier(String name, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.name = name;
        }

        public List<FormDataContentDisposition> get() {
            List<FormDataBodyPart> parts = this.getEntity().getFields(this.name);
            return parts == null ? null : Lists.transform(parts, (Function)new Function<FormDataBodyPart, FormDataContentDisposition>(){

                public FormDataContentDisposition apply(FormDataBodyPart part) {
                    return part.getFormDataContentDisposition();
                }
            });
        }
    }

    private final class ListFormDataBodyPartValueSupplier
    extends ValueSupplier<List<FormDataBodyPart>> {
        private final String name;

        public ListFormDataBodyPartValueSupplier(String name, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.name = name;
        }

        public List<FormDataBodyPart> get() {
            return this.getEntity().getFields(this.name);
        }
    }

    private final class FormDataMultiPartSupplier
    extends ValueSupplier<FormDataMultiPart> {
        public FormDataMultiPartSupplier(Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
        }

        public FormDataMultiPart get() {
            return this.getEntity();
        }
    }

    private abstract class ValueSupplier<T>
    extends AbstractRequestDerivedValueSupplier<T> {
        public ValueSupplier(Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
        }

        FormDataMultiPart getEntity() {
            String requestPropertyName;
            ContainerRequest request = this.getRequest();
            Object entity = request.getProperty(requestPropertyName = FormDataMultiPart.class.getName());
            if (entity == null) {
                entity = request.readEntity(FormDataMultiPart.class);
                if (entity == null) {
                    throw new BadRequestException(LocalizationMessages.ENTITY_IS_EMPTY());
                }
                request.setProperty(requestPropertyName, entity);
            }
            return (FormDataMultiPart)entity;
        }
    }
}

