
package org.glassfish.jersey.media.multipart.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.media.multipart.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableCONFIG_NOT_PRESENT() {
        return messageFactory.getMessage("config.not.present");
    }

    /**
     * The MultiPartProperties instance we expected is not present. Have you registered the MultiPartFeature class?
     * 
     */
    public static String CONFIG_NOT_PRESENT() {
        return localizer.localize(localizableCONFIG_NOT_PRESENT());
    }

    public static Localizable localizableCONTEXT_RESOLVER_NOT_PRESENT() {
        return messageFactory.getMessage("context.resolver.not.present");
    }

    /**
     * The ContextResolver<MultiPartProperties> instance we expected is not present. Have you registered the MultiPartFeature class?
     * 
     */
    public static String CONTEXT_RESOLVER_NOT_PRESENT() {
        return localizer.localize(localizableCONTEXT_RESOLVER_NOT_PRESENT());
    }

}
