/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.Nullable;
import org.glassfish.jersey.media.sse.EventChannel;

public class Broadcaster {
    private final ConcurrentSkipListSet<EventChannel> eventChannelSet = new ConcurrentSkipListSet<EventChannel>(new Comparator<EventChannel>(){

        @Override
        public int compare(EventChannel eventChannel, EventChannel eventChannel1) {
            return eventChannel.hashCode() - eventChannel1.hashCode();
        }
    });

    public void registerEventChannel(EventChannel eventChannel) {
        this.eventChannelSet.add(eventChannel);
    }

    public void broadcast(String eventName, String eventId, Class dataType, Object data) throws IllegalStateException, IllegalArgumentException {
        this._broadcast(eventName, eventId, dataType, data);
    }

    public void broadcast(String eventName, Object data, Class<?> dataType) throws IllegalStateException, IllegalArgumentException {
        this._broadcast(eventName, null, dataType, data);
    }

    public void broadcast(Object data, Class<?> dataType) throws IllegalStateException, IllegalArgumentException {
        this._broadcast(null, null, dataType, data);
    }

    private void _broadcast(@Nullable String eventName, @Nullable String eventId, Class<?> dataType, Object data) throws IllegalStateException, IllegalArgumentException {
        Iterator<EventChannel> iterator = this.eventChannelSet.iterator();
        while (iterator.hasNext()) {
            EventChannel eventChannel = iterator.next();
            if (eventChannel.isClosed()) {
                iterator.remove();
                continue;
            }
            eventChannel.write(eventName, eventId, data, dataType);
        }
    }

    public void close() {
        for (EventChannel eventChannel : this.eventChannelSet) {
            eventChannel.close();
        }
    }
}

