/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;

public class EventChannel {
    public static final String SERVER_SENT_EVENTS = "text/event-stream";
    public static final MediaType SERVER_SENT_EVENTS_TYPE = MediaType.valueOf((String)"text/event-stream");
    private final long interval;
    private final TimeUnit timeUnit;
    private BlockingDeque<Event> queue = new LinkedBlockingDeque<Event>();
    private boolean closed = false;

    public EventChannel() {
        this(null, null);
    }

    public EventChannel(Long interval, TimeUnit timeUnit) {
        this.interval = interval == null ? 5L : interval;
        this.timeUnit = timeUnit == null ? TimeUnit.SECONDS : timeUnit;
    }

    public void write(String eventName, String eventId, Object data, Class<?> dataType) throws IllegalStateException, IllegalArgumentException {
        this._send(eventName, eventId, dataType, data);
    }

    public void write(String eventName, Object data, Class<?> dataType) throws IllegalStateException, IllegalArgumentException {
        this._send(eventName, null, dataType, data);
    }

    public void write(Object data, Class<?> dataType) throws IllegalStateException, IllegalArgumentException {
        this._send(null, null, dataType, data);
    }

    private void _send(@Nullable String eventName, @Nullable String eventId, Class<?> dataType, Object data) throws IllegalStateException, IllegalArgumentException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (dataType == null || data == null) {
            throw new IllegalArgumentException();
        }
        this.queue.add(new Event(eventName, eventId, dataType, data));
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.queue.add(new Event(null, null, null, null));
        this.closed = true;
    }

    Event getMessageToWrite() throws InterruptedException {
        if (this.closed) {
            return null;
        }
        return this.queue.poll(this.interval, this.timeUnit);
    }

    void clientClose() {
        this.closed = true;
    }

    class Event {
        private final String name;
        private final String id;
        private final Class type;
        private final Object data;

        Event(String name, String id, Class type, Object data) {
            this.name = name;
            this.id = id;
            this.type = type;
            this.data = data;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public Class getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }
    }
}

