/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.media.sse.EventChannel;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.jvnet.hk2.annotations.Inject;

@Provider
public class EventChannelWriter
implements MessageBodyWriter<EventChannel> {
    private final Services services;

    public EventChannelWriter(@Inject Services services) {
        this.services = services;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return EventChannel.class.equals(type) && mediaType.equals((Object)EventChannel.SERVER_SENT_EVENTS_TYPE);
    }

    public long getSize(EventChannel eventChannel, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(EventChannel eventChannel, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        References references = (References)((Injector)this.services.forContract(Injector.class).get()).inject(References.class);
        entityStream.write(new byte[]{58, 10});
        entityStream.flush();
        do {
            EventChannel.Event event;
            try {
                event = eventChannel.getMessageToWrite();
            }
            catch (InterruptedException e) {
                event = null;
            }
            if (event == null || event.getType() == null) continue;
            MessageBodyWorkers messageBodyWorkers = (MessageBodyWorkers)references.messageBodyWorkers.get();
            MessageBodyWriter messageBodyWriter = messageBodyWorkers.getMessageBodyWriter(event.getType(), null, annotations, MediaType.TEXT_PLAIN_TYPE);
            if (event.getName() != null) {
                entityStream.write(String.format("event: %s\n", event.getName()).getBytes());
            }
            if (event.getId() != null) {
                entityStream.write(String.format("id: %s\n", event.getName()).getBytes());
            }
            try {
                messageBodyWriter.writeTo(event.getData(), event.getClass(), null, annotations, mediaType, httpHeaders, new OutputStream(){
                    private boolean start = true;

                    @Override
                    public void write(int i) throws IOException {
                        if (this.start) {
                            entityStream.write("data: ".getBytes());
                            this.start = false;
                        }
                        entityStream.write(i);
                        if (i == 10) {
                            entityStream.write("data: ".getBytes());
                        }
                    }
                });
            }
            catch (IOException e) {
                eventChannel.clientClose();
                throw e;
            }
            entityStream.write("\n\n".getBytes());
            entityStream.flush();
        } while (!eventChannel.isClosed());
    }

    private static final class References {
        @Inject
        private Ref<MessageBodyWorkers> messageBodyWorkers;

        private References() {
        }
    }
}

