/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.media.sse.Event;
import org.glassfish.jersey.media.sse.EventSource;
import org.glassfish.jersey.message.MessageBodyWorkers;

final class EventReceiver
implements Closeable {
    private final InputStream inputStream;
    private final Annotation[] annotations;
    private final MediaType mediaType;
    private final MultivaluedMap<String, String> headers;
    private final MessageBodyWorkers messageBodyWorkers;
    private boolean closed = false;

    private void processField(Event event, String name, byte[] value) {
        if (name.equals("event")) {
            event.setName(new String(value));
        } else if (name.equals("data")) {
            event.addData(value);
            event.addData(new byte[]{10});
        } else if (name.equals("id")) {
            String s = new String(value);
            try {
                Integer.parseInt(new String(value));
            }
            catch (NumberFormatException nfe) {
                s = "";
            }
            event.setId(s);
        } else if (name.equals("retry")) {
            // empty if block
        }
    }

    void process(@Nullable LinkedBlockingQueue<Event> eventQueue, @Nullable EventSource eventSource) {
        Event event = new Event(this.messageBodyWorkers, this.annotations, this.mediaType, this.headers);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        State currentState = State.START;
        String fieldName = null;
        try {
            int data = 0;
            while (currentState != State.EVENT_FIRED && (data = this.inputStream.read()) != -1) {
                switch (currentState) {
                    case START: {
                        if (data == 58) {
                            currentState = State.COMMENT;
                            break;
                        }
                        if (data != 10) {
                            baos.write(data);
                            currentState = State.FIELD_NAME;
                            break;
                        }
                        if (data != 10) break;
                        if (!event.isEmpty()) {
                            if (eventQueue != null) {
                                eventQueue.add(event);
                            }
                            if (eventSource != null) {
                                eventSource.onReceivedEvent(event);
                            }
                            currentState = State.EVENT_FIRED;
                        }
                        event = new Event(this.messageBodyWorkers, this.annotations, this.mediaType, this.headers);
                        break;
                    }
                    case COMMENT: {
                        if (data != 10) break;
                        currentState = State.START;
                        break;
                    }
                    case FIELD_NAME: {
                        if (data == 58) {
                            fieldName = baos.toString();
                            baos.reset();
                            currentState = State.FIELD_VALUE_FIRST;
                            break;
                        }
                        if (data == 10) {
                            this.processField(event, baos.toString(), "".getBytes());
                            baos.reset();
                            currentState = State.START;
                            break;
                        }
                        baos.write(data);
                        break;
                    }
                    case FIELD_VALUE_FIRST: {
                        if (data != 32) {
                            baos.write(data);
                        }
                        if (data == 10) {
                            this.processField(event, fieldName, baos.toByteArray());
                            baos.reset();
                            currentState = State.START;
                            break;
                        }
                        currentState = State.FIELD_VALUE;
                        break;
                    }
                    case FIELD_VALUE: {
                        if (data == 10) {
                            this.processField(event, fieldName, baos.toByteArray());
                            baos.reset();
                            currentState = State.START;
                            break;
                        }
                        baos.write(data);
                    }
                }
            }
            if (data == -1) {
                this.closed = true;
            }
        }
        catch (IOException e) {
            this.closed = true;
        }
    }

    EventReceiver(InputStream inputStream, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, MessageBodyWorkers messageBodyWorkers) {
        this.inputStream = inputStream;
        this.annotations = annotations;
        this.mediaType = mediaType;
        this.headers = headers;
        this.messageBodyWorkers = messageBodyWorkers;
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.inputStream.close();
    }

    private static enum State {
        START,
        COMMENT,
        FIELD_NAME,
        FIELD_VALUE_FIRST,
        FIELD_VALUE,
        EVENT_FIRED;

    }
}

