/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.client.Target;
import org.glassfish.jersey.media.sse.Event;
import org.glassfish.jersey.media.sse.EventListener;
import org.glassfish.jersey.media.sse.EventProcessor;
import org.glassfish.jersey.media.sse.EventProcessorReader;

public class EventSource
implements EventListener {
    private final Target target;
    private final ConcurrentSkipListSet<EventListener> generalListeners = new ConcurrentSkipListSet<EventListener>(new Comparator<EventListener>(){

        @Override
        public int compare(EventListener eventListener, EventListener eventListener1) {
            return eventListener.hashCode() - eventListener1.hashCode();
        }
    });
    private final ConcurrentSkipListMap<String, List<EventListener>> namedListeners = new ConcurrentSkipListMap();

    public EventSource(Target target) {
        this.target = target;
        Executors.newCachedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                EventSource.this.process();
            }
        });
    }

    public EventSource(Target target, ExecutorService executorService) {
        this.target = target;
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                EventSource.this.process();
            }
        });
    }

    public void addEventListener(EventListener listener) {
        this.addEventListener(null, listener);
    }

    public void addEventListener(String eventName, EventListener listener) {
        if (eventName == null) {
            this.generalListeners.add(listener);
        } else {
            List<EventListener> eventListeners = this.namedListeners.get(eventName);
            if (eventListeners == null) {
                this.namedListeners.put(eventName, Arrays.asList(listener));
            } else {
                eventListeners.add(listener);
            }
        }
    }

    private void process() {
        this.target.configuration().register(EventProcessorReader.class);
        EventProcessor eventProcessor = (EventProcessor)this.target.request().get(EventProcessor.class);
        eventProcessor.process(this);
    }

    private void notifyListeners(Event event, Collection<EventListener> listeners) {
        for (EventListener eventListener : listeners) {
            eventListener.onEvent(event);
        }
    }

    void onReceivedEvent(Event event) {
        List<EventListener> eventListeners;
        this.onEvent(event);
        this.notifyListeners(event, this.generalListeners);
        String eventName = event.getName();
        if (eventName != null && (eventListeners = this.namedListeners.get(eventName)) != null) {
            this.notifyListeners(event, eventListeners);
        }
    }

    @Override
    public void onEvent(Event event) {
    }
}

