/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.message.MessageBodyWorkers;

public class OutboundEventWriter
implements MessageBodyWriter<OutboundEvent> {
    @Inject
    private ServiceLocator locator;
    @Inject
    private Provider<MessageBodyWorkers> workersProvider;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(OutboundEvent.class);
    }

    public long getSize(OutboundEvent incomingEvent, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(OutboundEvent outboundEvent, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        if (outboundEvent.getComment() != null) {
            entityStream.write(String.format(": %s\n", outboundEvent.getComment()).getBytes());
        }
        if (outboundEvent.getType() != null) {
            MessageBodyWriter messageBodyWriter = ((MessageBodyWorkers)this.workersProvider.get()).getMessageBodyWriter(outboundEvent.getType(), null, annotations, outboundEvent.getMediaType() == null ? MediaType.TEXT_PLAIN_TYPE : outboundEvent.getMediaType());
            if (outboundEvent.getName() != null) {
                entityStream.write(String.format("event: %s\n", outboundEvent.getName()).getBytes());
            }
            if (outboundEvent.getId() != null) {
                entityStream.write(String.format("id: %s\n", outboundEvent.getId()).getBytes());
            }
            messageBodyWriter.writeTo(outboundEvent.getData(), outboundEvent.getClass(), null, annotations, mediaType, httpHeaders, new OutputStream(){
                private boolean start = true;

                @Override
                public void write(int i) throws IOException {
                    if (this.start) {
                        entityStream.write("data: ".getBytes());
                        this.start = false;
                    }
                    entityStream.write(i);
                    if (i == 10) {
                        entityStream.write("data: ".getBytes());
                    }
                }
            });
        }
        entityStream.write("\n\n".getBytes());
        entityStream.flush();
    }
}

