/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.media.sse.EventListener;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.message.MessageBodyWorkers;

public final class EventProcessor
implements Closeable {
    private final InputStream inputStream;
    private final Annotation[] annotations;
    private final MediaType mediaType;
    private final MultivaluedMap<String, String> headers;
    private final MessageBodyWorkers messageBodyWorkers;
    private volatile boolean closed;

    EventProcessor(InputStream inputStream, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, MessageBodyWorkers messageBodyWorkers) {
        this.inputStream = inputStream;
        this.annotations = annotations;
        this.mediaType = mediaType;
        this.headers = headers;
        this.messageBodyWorkers = messageBodyWorkers;
    }

    public void process(EventListener eventListener) {
        while (true) {
            if (this.closed) {
                try {
                    this.inputStream.close();
                    break;
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, e.getMessage(), e);
                    continue;
                }
            }
            this.nextEvent(eventListener);
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void nextEvent(EventListener listener) {
        InboundEvent inboundEvent = new InboundEvent(this.messageBodyWorkers, this.annotations, this.mediaType, this.headers);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        State currentState = State.START;
        String fieldName = null;
        try {
            int data = 0;
            while (currentState != State.EVENT_FIRED && (data = this.inputStream.read()) != -1) {
                switch (currentState) {
                    case START: {
                        if (data == 58) {
                            currentState = State.COMMENT;
                            break;
                        }
                        if (data != 10) {
                            baos.write(data);
                            currentState = State.FIELD_NAME;
                            break;
                        }
                        if (data != 10) break;
                        if (!inboundEvent.isEmpty()) {
                            listener.onEvent(inboundEvent);
                            currentState = State.EVENT_FIRED;
                        }
                        inboundEvent = new InboundEvent(this.messageBodyWorkers, this.annotations, this.mediaType, this.headers);
                        break;
                    }
                    case COMMENT: {
                        if (data != 10) break;
                        currentState = State.START;
                        break;
                    }
                    case FIELD_NAME: {
                        if (data == 58) {
                            fieldName = baos.toString();
                            baos.reset();
                            currentState = State.FIELD_VALUE_FIRST;
                            break;
                        }
                        if (data == 10) {
                            this.processField(inboundEvent, baos.toString(), "".getBytes());
                            baos.reset();
                            currentState = State.START;
                            break;
                        }
                        baos.write(data);
                        break;
                    }
                    case FIELD_VALUE_FIRST: {
                        if (data != 32) {
                            baos.write(data);
                        }
                        if (data == 10) {
                            this.processField(inboundEvent, fieldName, baos.toByteArray());
                            baos.reset();
                            currentState = State.START;
                            break;
                        }
                        currentState = State.FIELD_VALUE;
                        break;
                    }
                    case FIELD_VALUE: {
                        if (data == 10) {
                            this.processField(inboundEvent, fieldName, baos.toByteArray());
                            baos.reset();
                            currentState = State.START;
                            break;
                        }
                        baos.write(data);
                    }
                }
            }
            if (data == -1) {
                this.close();
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, e.getMessage(), e);
            this.close();
        }
    }

    private void processField(InboundEvent inboundEvent, String name, byte[] value) {
        if (name.equals("event")) {
            inboundEvent.setName(new String(value));
        } else if (name.equals("data")) {
            inboundEvent.addData(value);
            inboundEvent.addData(new byte[]{10});
        } else if (name.equals("id")) {
            String s = new String(value);
            try {
                Integer.parseInt(new String(value));
            }
            catch (NumberFormatException nfe) {
                s = "";
            }
            inboundEvent.setId(s);
        } else if (name.equals("retry")) {
            // empty if block
        }
    }

    private static enum State {
        START,
        COMMENT,
        FIELD_NAME,
        FIELD_VALUE_FIRST,
        FIELD_VALUE,
        EVENT_FIRED;

    }
}

