/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.media.sse.EventListener;
import org.glassfish.jersey.media.sse.EventProcessor;
import org.glassfish.jersey.media.sse.EventProcessorReader;
import org.glassfish.jersey.media.sse.InboundEvent;

public class EventSource
implements EventListener {
    private final WebTarget target;
    private volatile EventProcessor processor;
    private boolean close = false;
    private final EventListener processorListener = new EventListener(){

        @Override
        public void onEvent(InboundEvent inboundEvent) {
            List eventListeners;
            EventSource.this.onEvent(inboundEvent);
            EventSource.this.notifyListeners(inboundEvent, EventSource.this.generalListeners);
            String eventName = inboundEvent.getName();
            if (eventName != null && (eventListeners = (List)EventSource.this.namedListeners.get(eventName)) != null) {
                EventSource.this.notifyListeners(inboundEvent, eventListeners);
            }
        }
    };
    private final ConcurrentSkipListSet<EventListener> generalListeners = new ConcurrentSkipListSet<EventListener>(new Comparator<EventListener>(){

        @Override
        public int compare(EventListener eventListener, EventListener eventListener1) {
            return eventListener.hashCode() - eventListener1.hashCode();
        }
    });
    private final ConcurrentSkipListMap<String, List<EventListener>> namedListeners = new ConcurrentSkipListMap();

    public EventSource(WebTarget target) {
        this(target, Executors.newSingleThreadExecutor());
    }

    public EventSource(WebTarget target, ExecutorService executorService) {
        this.target = target;
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                EventSource.this.process();
            }
        });
    }

    public void addEventListener(EventListener listener) {
        this.addEventListener(null, listener);
    }

    public void addEventListener(String eventName, EventListener listener) {
        if (eventName == null) {
            this.generalListeners.add(listener);
        } else {
            List<EventListener> eventListeners = this.namedListeners.get(eventName);
            if (eventListeners == null) {
                this.namedListeners.put(eventName, Arrays.asList(listener));
            } else {
                eventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        this.target.configuration().register(EventProcessorReader.class);
        this.processor = (EventProcessor)this.target.request().get(EventProcessor.class);
        EventSource eventSource = this;
        synchronized (eventSource) {
            if (this.close) {
                this.processor.close();
                return;
            }
        }
        this.processor.process(this.processorListener);
    }

    private void notifyListeners(InboundEvent inboundEvent, Collection<EventListener> listeners) {
        for (EventListener eventListener : listeners) {
            eventListener.onEvent(inboundEvent);
        }
    }

    @Override
    public void onEvent(InboundEvent inboundEvent) {
    }

    public synchronized void close() {
        if (this.processor != null) {
            this.processor.close();
        } else {
            this.close = true;
        }
    }
}

