/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.ChunkedInput;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.EventInputReader;
import org.glassfish.jersey.media.sse.EventListener;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.InboundEventReader;
import org.glassfish.jersey.media.sse.LocalizationMessages;
import org.glassfish.jersey.media.sse.SseFeature;

public class EventSource
implements EventListener {
    private static final Logger LOGGER = Logger.getLogger(EventSource.class.getName());
    private final WebTarget target;
    private ExecutorService executorService;
    private Future<?> process;
    private final Object connectionLock = new Object();
    private final EventListener listenerAggregator = new EventListener(){

        @Override
        public void onEvent(InboundEvent inboundEvent) {
            List eventListeners;
            EventSource.this.onEvent(inboundEvent);
            EventSource.notify(inboundEvent, EventSource.this.unboundListeners);
            String eventName = inboundEvent.getName();
            if (eventName != null && (eventListeners = (List)EventSource.this.boundListeners.get(eventName)) != null) {
                EventSource.notify(inboundEvent, eventListeners);
            }
        }
    };
    private final List<EventListener> unboundListeners = new CopyOnWriteArrayList<EventListener>();
    private final ConcurrentMap<String, List<EventListener>> boundListeners = new ConcurrentHashMap<String, List<EventListener>>();

    public EventSource(WebTarget target) throws NullPointerException {
        this(target, true);
    }

    public EventSource(WebTarget target, boolean open) {
        if (target == null) {
            throw new NullPointerException("Web target is 'null'.");
        }
        ((WebTarget)target.register(InboundEventReader.class)).register(EventInputReader.class);
        this.target = target;
        if (open) {
            this.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IllegalStateException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.process != null) {
                throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CONNECTED());
            }
            this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, String.format("jersey-sse-event-source-[%s]", EventSource.this.target.getUri().toASCIIString()));
                }
            });
            final EventInput eventInput = (EventInput)((Object)this.target.request(new MediaType[]{SseFeature.SERVER_SENT_EVENTS_TYPE}).get(EventInput.class));
            eventInput.setParser(ChunkedInput.createParser((String)"\n\n"));
            final Future<?> p = this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!eventInput.isClosed()) {
                        EventListener eventListener = EventSource.this.listenerAggregator;
                        synchronized (eventListener) {
                            InboundEvent event = (InboundEvent)eventInput.read();
                            if (event != null) {
                                EventSource.this.listenerAggregator.onEvent(event);
                            }
                        }
                    }
                }
            });
            this.process = new Future<Object>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    eventInput.close();
                    return p.cancel(mayInterruptIfRunning);
                }

                @Override
                public boolean isCancelled() {
                    return p.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return p.isDone();
                }

                @Override
                public Object get() throws InterruptedException, ExecutionException {
                    return p.get();
                }

                @Override
                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return p.get(timeout, unit);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.process != null;
        }
    }

    public void register(EventListener listener) {
        this.register(listener, null, new String[0]);
    }

    public void register(EventListener listener, String eventName, String ... eventNames) {
        if (eventName == null) {
            this.unboundListeners.add(listener);
        } else {
            this.addBoundListener(eventName, listener);
            if (eventNames != null) {
                for (String name : eventNames) {
                    this.addBoundListener(name, listener);
                }
            }
        }
    }

    private void addBoundListener(String name, EventListener listener) {
        List listeners = (List)this.boundListeners.get(name);
        if (listeners == null) {
            listeners = this.boundListeners.putIfAbsent(name, new CopyOnWriteArrayList());
        }
        listeners.add(listener);
    }

    private static void notify(InboundEvent inboundEvent, Collection<EventListener> listeners) {
        for (EventListener listener : listeners) {
            listener.onEvent(inboundEvent);
        }
    }

    @Override
    public void onEvent(InboundEvent inboundEvent) {
    }

    public void close() {
        this.close(5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(long timeout, TimeUnit unit) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.process == null) {
                return true;
            }
            this.process.cancel(true);
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(timeout, unit)) {
                    LOGGER.warning(LocalizationMessages.EVENT_SOURCE_SHUTDOWN_TIMEOUT(this.target.getUri().toString()));
                    return false;
                }
            }
            catch (InterruptedException e) {
                LOGGER.fine(LocalizationMessages.EVENT_SOURCE_SHUTDOWN_INTERRUPTED(this.target.getUri().toString()));
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }
}

