/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.jersey.media.sse.LocalizationMessages;
import org.glassfish.jersey.message.MessageBodyWorkers;

public class InboundEvent {
    private final String name;
    private final String id;
    private final byte[] data;
    private final MessageBodyWorkers messageBodyWorkers;
    private final Annotation[] annotations;
    private final MediaType mediaType;
    private final MultivaluedMap<String, String> headers;

    private InboundEvent(String name, String id, byte[] data, MessageBodyWorkers messageBodyWorkers, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers) {
        this.name = name;
        this.id = id;
        this.data = data;
        this.messageBodyWorkers = messageBodyWorkers;
        this.annotations = annotations;
        this.mediaType = mediaType;
        this.headers = headers;
    }

    boolean isEmpty() {
        return this.data.length == 0;
    }

    public String getName() {
        return this.name;
    }

    public <T> T getData(Class<T> messageType) throws IOException {
        return this.getData(messageType, null);
    }

    public <T> T getData(Class<T> messageType, MediaType mediaType) throws IOException {
        MediaType effectiveMediaType = mediaType == null ? this.mediaType : mediaType;
        MessageBodyReader reader = this.messageBodyWorkers.getMessageBodyReader(messageType, null, this.annotations, mediaType);
        if (reader == null) {
            throw new IllegalStateException(LocalizationMessages.EVENT_DATA_READER_NOT_FOUND());
        }
        return (T)reader.readFrom(messageType, null, this.annotations, effectiveMediaType, this.headers, (InputStream)new ByteArrayInputStream(this.stripLastLineBreak(this.data)));
    }

    public String getData() throws IOException {
        return this.getData(String.class);
    }

    public String toString() {
        String s;
        try {
            s = this.getData();
        }
        catch (IOException e) {
            s = "";
        }
        return "InboundEvent{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", data=" + s + '}';
    }

    private byte[] stripLastLineBreak(byte[] data) {
        if (data.length >= 1 && data[data.length - 1] == 10) {
            byte[] newArray = new byte[data.length - 1];
            System.arraycopy(data, 0, newArray, 0, data.length - 1);
            data = newArray;
        }
        return data;
    }

    static class Builder {
        private String name;
        private String id;
        private ByteArrayOutputStream dataStream;
        private final MessageBodyWorkers workers;
        private final Annotation[] annotations;
        private final MediaType mediaType;
        private final MultivaluedMap<String, String> headers;

        Builder(MessageBodyWorkers workers, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers) {
            this.workers = workers;
            this.annotations = annotations;
            this.mediaType = mediaType;
            this.headers = headers;
            this.dataStream = new ByteArrayOutputStream();
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder data(byte[] data) {
            if (data == null || data.length == 0) {
                return this;
            }
            try {
                this.dataStream.write(data);
            }
            catch (IOException e) {
                this.dataStream = null;
            }
            return this;
        }

        public InboundEvent build() {
            return new InboundEvent(this.name, this.id, this.dataStream.toByteArray(), this.workers, this.annotations, this.mediaType, this.headers);
        }
    }
}

