
package org.glassfish.jersey.media.sse;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.media.sse.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableEVENT_SOURCE_SHUTDOWN_INTERRUPTED(Object arg0) {
        return messageFactory.getMessage("event.source.shutdown.interrupted", arg0);
    }

    /**
     * Waiting for the event source executor for [{0}] to shutdown has been interrupted.
     * 
     */
    public static String EVENT_SOURCE_SHUTDOWN_INTERRUPTED(Object arg0) {
        return localizer.localize(localizableEVENT_SOURCE_SHUTDOWN_INTERRUPTED(arg0));
    }

    public static Localizable localizableEVENT_SOURCE_SHUTDOWN_TIMEOUT(Object arg0) {
        return messageFactory.getMessage("event.source.shutdown.timeout", arg0);
    }

    /**
     * Attempt to shutdown the event source executor for [{0}] has timed out.
     * 
     */
    public static String EVENT_SOURCE_SHUTDOWN_TIMEOUT(Object arg0) {
        return localizer.localize(localizableEVENT_SOURCE_SHUTDOWN_TIMEOUT(arg0));
    }

    public static Localizable localizableEVENT_DATA_READER_NOT_FOUND() {
        return messageFactory.getMessage("event.data.reader.not.found");
    }

    /**
     * Message body reader not found for the SSE event data.
     * 
     */
    public static String EVENT_DATA_READER_NOT_FOUND() {
        return localizer.localize(localizableEVENT_DATA_READER_NOT_FOUND());
    }

    public static Localizable localizableEVENT_SOURCE_ALREADY_CONNECTED() {
        return messageFactory.getMessage("event.source.already.connected");
    }

    /**
     * This event source is already opened.
     * 
     */
    public static String EVENT_SOURCE_ALREADY_CONNECTED() {
        return localizer.localize(localizableEVENT_SOURCE_ALREADY_CONNECTED());
    }

}
