/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse.internal;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.sse.InboundSseEvent;
import javax.ws.rs.sse.SseEventSource;
import org.glassfish.jersey.client.ClientExecutor;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.glassfish.jersey.internal.jsr166.Flow;
import org.glassfish.jersey.internal.util.JerseyPublisher;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.LocalizationMessages;
import org.glassfish.jersey.media.sse.internal.SseEventListener;

public class JerseySseEventSource
implements SseEventSource,
SseEventListener<InboundSseEvent> {
    private static final long DEFAULT_RECONNECT_DELAY = 500L;
    private static final Level CONNECTION_ERROR_LEVEL = Level.FINE;
    private static final Logger LOGGER = Logger.getLogger(JerseySseEventSource.class.getName());
    private static final Consumer<Flow.Subscription> DEFAULT_SUBSCRIPTION_HANDLER = sseSubscription -> sseSubscription.request(Long.MAX_VALUE);
    private static final Consumer<Throwable> DEFAULT_ERROR_HANDLER = throwable -> LOGGER.log(Level.WARNING, LocalizationMessages.EVENT_SOURCE_DEFAULT_ONERROR(), (Throwable)throwable);
    private static final String LAST_EVENT_ID_HEADER = "Last-Event-ID";
    private JerseyPublisher<InboundSseEvent> publisher;
    private final AtomicReference<State> state = new AtomicReference<State>(State.READY);
    private final JerseyWebTarget endpoint;
    private final long reconnectDelay;
    private final TimeUnit reconnectTimeUnit;
    private final ClientExecutor clientExecutor;

    private JerseySseEventSource(JerseyWebTarget endpoint, long reconnectDelay, TimeUnit reconnectTimeUnit) {
        this.endpoint = endpoint;
        this.reconnectDelay = reconnectDelay;
        this.reconnectTimeUnit = reconnectTimeUnit;
        this.clientExecutor = endpoint.getConfiguration().getClientExecutor();
        this.publisher = new JerseyPublisher(arg_0 -> ((ClientExecutor)this.clientExecutor).submit(arg_0), JerseyPublisher.PublisherStrategy.BLOCKING);
    }

    @Override
    public void onEvent(InboundSseEvent inboundEvent) {
        this.publisher.publish((Object)inboundEvent);
    }

    public void register(Consumer<InboundSseEvent> onEvent) {
        this.subscribe(DEFAULT_SUBSCRIPTION_HANDLER, onEvent, DEFAULT_ERROR_HANDLER, () -> {});
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError) {
        this.subscribe(DEFAULT_SUBSCRIPTION_HANDLER, onEvent, onError, () -> {});
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError, Runnable onComplete) {
        this.subscribe(DEFAULT_SUBSCRIPTION_HANDLER, onEvent, onError, onComplete);
    }

    public void subscribe(final Consumer<Flow.Subscription> onSubscribe, final Consumer<InboundSseEvent> onEvent, final Consumer<Throwable> onError, final Runnable onComplete) {
        if (onSubscribe == null || onEvent == null || onError == null || onComplete == null) {
            throw new IllegalStateException(LocalizationMessages.PARAMS_NULL());
        }
        this.publisher.subscribe((Flow.Subscriber)new Flow.Subscriber<InboundSseEvent>(){

            public void onSubscribe(final Flow.Subscription subscription) {
                onSubscribe.accept(new Flow.Subscription(){

                    public void request(long n) {
                        subscription.request(n);
                    }

                    public void cancel() {
                        subscription.cancel();
                    }
                });
            }

            public void onNext(InboundSseEvent item) {
                onEvent.accept(item);
            }

            public void onError(Throwable throwable) {
                onError.accept(throwable);
            }

            public void onComplete() {
                onComplete.run();
            }
        });
    }

    public void open() {
        if (!this.state.compareAndSet(State.READY, State.OPEN)) {
            switch (this.state.get()) {
                case CLOSED: {
                    throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CLOSED());
                }
                case OPEN: {
                    throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CONNECTED());
                }
            }
        }
        EventProcessor processor = new EventProcessor(this.reconnectDelay, this.reconnectTimeUnit, null);
        this.clientExecutor.submit((Runnable)processor);
        processor.awaitFirstContact();
    }

    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    public boolean close(long timeout, TimeUnit unit) {
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            this.publisher.close();
        }
        return true;
    }

    private class EventProcessor
    implements Runnable,
    SseEventListener<InboundSseEvent> {
        private final CountDownLatch firstContactSignal;
        private String lastEventId;
        private long reconnectDelay;
        private final TimeUnit reconnectTimeUnit;

        EventProcessor(long reconnectDelay, TimeUnit reconnectTimeUnit, String lastEventId) {
            this.firstContactSignal = new CountDownLatch(1);
            this.reconnectDelay = reconnectDelay;
            this.reconnectTimeUnit = reconnectTimeUnit;
            this.lastEventId = lastEventId;
        }

        private EventProcessor(EventProcessor that) {
            this.firstContactSignal = null;
            this.reconnectDelay = that.reconnectDelay;
            this.reconnectTimeUnit = that.reconnectTimeUnit;
            this.lastEventId = that.lastEventId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.fine("Listener task started");
            EventInput eventInput = null;
            try {
                try {
                    Invocation.Builder request = this.prepareHandshakeRequest();
                    if (JerseySseEventSource.this.state.get() == State.OPEN) {
                        eventInput = (EventInput)((Object)request.get(EventInput.class));
                    }
                }
                finally {
                    if (this.firstContactSignal != null) {
                        this.firstContactSignal.countDown();
                    }
                }
                Thread execThread = Thread.currentThread();
                while (JerseySseEventSource.this.state.get() == State.OPEN && !execThread.isInterrupted()) {
                    if (eventInput == null || eventInput.isClosed()) {
                        LOGGER.fine(String.format("Connection lost - scheduling reconnect in %s %s", new Object[]{this.reconnectDelay, this.reconnectTimeUnit}));
                        this.scheduleReconnect(this.reconnectDelay, this.reconnectTimeUnit);
                        break;
                    }
                    this.onEvent((InboundSseEvent)eventInput.read());
                }
            }
            catch (ServiceUnavailableException ex) {
                LOGGER.fine("Received HTTP 503");
                long delay = this.reconnectDelay;
                TimeUnit timeUnit = this.reconnectTimeUnit;
                if (ex.hasRetryAfter()) {
                    LOGGER.fine("Recovering from HTTP 503 using HTTP Retry-After header value as a reconnect delay.");
                    Date requestTime = new Date();
                    delay = ex.getRetryTime(requestTime).getTime() - requestTime.getTime();
                    delay = delay > 0L ? delay : 0L;
                    timeUnit = TimeUnit.MILLISECONDS;
                }
                LOGGER.fine(String.format("Recovering from HTTP 503 - scheduling to reconnect in %s %s", new Object[]{delay, timeUnit}));
                this.scheduleReconnect(delay, timeUnit);
            }
            catch (Exception ex) {
                if (LOGGER.isLoggable(CONNECTION_ERROR_LEVEL)) {
                    LOGGER.log(CONNECTION_ERROR_LEVEL, String.format("Unable to connect - closing the event source to %s.", JerseySseEventSource.this.endpoint.getUri().toASCIIString()), ex);
                }
                JerseySseEventSource.this.close();
            }
            finally {
                if (eventInput != null && !eventInput.isClosed()) {
                    eventInput.close();
                }
                LOGGER.fine("Listener task finished.");
            }
        }

        private void scheduleReconnect(long reconnectDelay, TimeUnit reconnectTimeUnit) {
            State s = (State)((Object)JerseySseEventSource.this.state.get());
            if (s != State.OPEN) {
                LOGGER.fine(String.format("Aborting reconnect of event source in %s state", JerseySseEventSource.this.state));
                return;
            }
            EventProcessor processor = new EventProcessor(this);
            if (reconnectDelay > 0L) {
                JerseySseEventSource.this.clientExecutor.schedule((Runnable)processor, reconnectDelay, reconnectTimeUnit);
            } else {
                JerseySseEventSource.this.clientExecutor.submit((Runnable)processor);
            }
        }

        private Invocation.Builder prepareHandshakeRequest() {
            JerseyInvocation.Builder request = JerseySseEventSource.this.endpoint.request(new String[]{"text/event-stream"});
            if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                request.header(JerseySseEventSource.LAST_EVENT_ID_HEADER, (Object)this.lastEventId);
            }
            request.header("Connection", (Object)"close");
            return request;
        }

        @Override
        public void onEvent(InboundSseEvent inboundEvent) {
            if (inboundEvent == null) {
                return;
            }
            LOGGER.fine("New event received: " + inboundEvent);
            if (inboundEvent.getId() != null) {
                this.lastEventId = inboundEvent.getId();
            }
            if (inboundEvent.isReconnectDelaySet()) {
                this.reconnectDelay = inboundEvent.getReconnectDelay();
            }
            JerseySseEventSource.this.publisher.publish((Object)inboundEvent);
        }

        void awaitFirstContact() {
            LOGGER.fine("Awaiting first contact signal.");
            try {
                if (this.firstContactSignal == null) {
                    return;
                }
                try {
                    this.firstContactSignal.await();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(CONNECTION_ERROR_LEVEL, LocalizationMessages.EVENT_SOURCE_OPEN_CONNECTION_INTERRUPTED(), ex);
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                LOGGER.fine("First contact signal released.");
            }
        }
    }

    public static class Builder
    extends SseEventSource.Builder {
        private WebTarget endpoint;
        private long reconnectDelay = 500L;
        private TimeUnit reconnectTimeUnit = TimeUnit.MILLISECONDS;

        protected Builder target(WebTarget endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder reconnectingEvery(long delay, TimeUnit unit) {
            this.reconnectDelay = delay;
            this.reconnectTimeUnit = unit;
            return this;
        }

        public JerseySseEventSource build() {
            if (this.endpoint instanceof JerseyWebTarget) {
                return new JerseySseEventSource((JerseyWebTarget)this.endpoint, this.reconnectDelay, this.reconnectTimeUnit);
            }
            throw new IllegalArgumentException(LocalizationMessages.UNSUPPORTED_WEBTARGET_TYPE(this.endpoint));
        }
    }

    private static enum State {
        READY,
        OPEN,
        CLOSED;

    }
}

