/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth1;

import javax.ws.rs.core.Feature;
import org.glassfish.jersey.client.oauth1.AccessToken;
import org.glassfish.jersey.client.oauth1.ConsumerCredentials;
import org.glassfish.jersey.client.oauth1.OAuth1AuthorizationFlowImpl;
import org.glassfish.jersey.client.oauth1.OAuth1Builder;
import org.glassfish.jersey.client.oauth1.OAuth1ClientFeature;
import org.glassfish.jersey.oauth1.signature.OAuth1Parameters;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;

class OAuth1BuilderImpl
implements OAuth1Builder {
    private final OAuth1Parameters params = new OAuth1Parameters();
    private final OAuth1Secrets secrets = new OAuth1Secrets();
    private ConsumerCredentials consumerCredentials;

    OAuth1BuilderImpl(ConsumerCredentials consumerCredentials) {
        this.params.setCallback("oob");
        this.consumerCredentials = consumerCredentials;
    }

    @Override
    public OAuth1BuilderImpl signatureMethod(String signatureMethod) {
        this.params.setSignatureMethod(signatureMethod);
        return this;
    }

    @Override
    public OAuth1BuilderImpl realm(String realm) {
        this.params.setRealm(realm);
        return this;
    }

    @Override
    public OAuth1BuilderImpl timestamp(String timestamp) {
        this.params.setTimestamp(timestamp);
        return this;
    }

    @Override
    public OAuth1BuilderImpl nonce(String timestamp) {
        this.params.setNonce(timestamp);
        return this;
    }

    @Override
    public OAuth1BuilderImpl version(String timestamp) {
        this.params.setVersion(timestamp);
        return this;
    }

    @Override
    public OAuth1Builder.FilterFeatureBuilder feature() {
        this.defineCredentialsParams();
        return new FilterBuilderImpl(this.params, this.secrets);
    }

    private void defineCredentialsParams() {
        this.params.setConsumerKey(this.consumerCredentials.getConsumerKey());
        this.secrets.setConsumerSecret(this.consumerCredentials.getConsumerSecret());
    }

    @Override
    public OAuth1Builder.FlowBuilder authorizationFlow(String requestTokenUri, String accessTokenUri, String authorizationUri) {
        this.defineCredentialsParams();
        return new OAuth1AuthorizationFlowImpl.Builder(this.consumerCredentials, requestTokenUri, accessTokenUri, authorizationUri);
    }

    static class FilterBuilderImpl
    implements OAuth1Builder.FilterFeatureBuilder {
        private final OAuth1Parameters params;
        private final OAuth1Secrets secrets;
        private AccessToken accessToken;

        FilterBuilderImpl(OAuth1Parameters params, OAuth1Secrets secrets) {
            this.params = params;
            this.secrets = secrets;
        }

        @Override
        public OAuth1Builder.FilterFeatureBuilder accessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Feature build() {
            if (this.accessToken != null) {
                this.params.setToken(this.accessToken.getToken());
                this.secrets.setTokenSecret(this.accessToken.getAccessTokenSecret());
            }
            return new OAuth1ClientFeature(this.params, this.secrets);
        }
    }
}

