/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth1;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.oauth1.RequestUtil;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.oauth1.signature.OAuth1Request;

class RequestWrapper
implements OAuth1Request {
    private final ClientRequestContext clientRequest;
    private final MessageBodyWorkers messageBodyWorkers;
    private MultivaluedMap<String, String> parameters = null;

    private void setParameters() {
        this.parameters = new MultivaluedHashMap();
        this.parameters.putAll(RequestUtil.getQueryParameters(this.clientRequest));
        this.parameters.putAll(RequestUtil.getEntityParameters(this.clientRequest, this.messageBodyWorkers));
    }

    public RequestWrapper(ClientRequestContext clientRequest, MessageBodyWorkers messageBodyWorkers) {
        this.clientRequest = clientRequest;
        this.messageBodyWorkers = messageBodyWorkers;
        this.setParameters();
    }

    public String getRequestMethod() {
        return this.clientRequest.getMethod();
    }

    public URL getRequestURL() {
        try {
            URI uri = this.clientRequest.getUri();
            return uri.toURL();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(RequestWrapper.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public List<String> getParameterValues(String name) {
        return (List)this.parameters.get((Object)name);
    }

    public List<String> getHeaderValues(String name) {
        ArrayList list = Lists.newArrayList();
        for (String header : (List)this.clientRequest.getStringHeaders().get((Object)name)) {
            list.add(header);
        }
        return list;
    }

    public void addHeaderValue(String name, String value) {
        this.clientRequest.getHeaders().add((Object)name, (Object)value);
    }
}

