/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth1;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import org.glassfish.jersey.client.oauth1.AccessToken;
import org.glassfish.jersey.client.oauth1.ConsumerCredentials;
import org.glassfish.jersey.client.oauth1.RequestWrapper;
import org.glassfish.jersey.client.oauth1.internal.LocalizationMessages;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.oauth1.signature.OAuth1Parameters;
import org.glassfish.jersey.oauth1.signature.OAuth1Request;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;
import org.glassfish.jersey.oauth1.signature.OAuth1Signature;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureException;

@Priority(value=1000)
class OAuth1ClientFilter
implements ClientRequestFilter {
    @Inject
    private Provider<OAuth1Signature> oAuthSignature;
    @Inject
    private Provider<MessageBodyWorkers> messageBodyWorkers;

    OAuth1ClientFilter() {
    }

    public void filter(ClientRequestContext request) throws IOException {
        ConsumerCredentials consumerFromProperties = (ConsumerCredentials)request.getProperty("jersey.config.client.oauth1.consumer.credentials");
        request.removeProperty("jersey.config.client.oauth1.consumer.credentials");
        AccessToken tokenFromProperties = (AccessToken)request.getProperty("jersey.config.client.oauth1.access.token");
        request.removeProperty("jersey.config.client.oauth1.access.token");
        OAuth1Parameters parameters = (OAuth1Parameters)request.getProperty("jersey.config.client.oauth1.parameters");
        if (parameters == null) {
            parameters = (OAuth1Parameters)request.getConfiguration().getProperty("jersey.config.client.oauth1.parameters");
        } else {
            request.removeProperty("jersey.config.client.oauth1.parameters");
        }
        OAuth1Secrets secrets = (OAuth1Secrets)request.getProperty("jersey.config.client.oauth1.secrets");
        if (secrets == null) {
            secrets = (OAuth1Secrets)request.getConfiguration().getProperty("jersey.config.client.oauth1.secrets");
        } else {
            request.removeProperty("jersey.config.client.oauth1.secrets");
        }
        if (request.getHeaders().containsKey((Object)"Authorization")) {
            return;
        }
        OAuth1Parameters paramCopy = parameters.clone();
        OAuth1Secrets secretsCopy = secrets.clone();
        this.checkParametersConsistency(paramCopy, secretsCopy);
        if (consumerFromProperties != null) {
            paramCopy.consumerKey(consumerFromProperties.getConsumerKey());
            secretsCopy.consumerSecret(consumerFromProperties.getConsumerSecret());
        }
        if (tokenFromProperties != null) {
            paramCopy.token(tokenFromProperties.getToken());
            secretsCopy.tokenSecret(tokenFromProperties.getAccessTokenSecret());
        }
        if (paramCopy.getTimestamp() == null) {
            paramCopy.setTimestamp();
        }
        if (paramCopy.getNonce() == null) {
            paramCopy.setNonce();
        }
        try {
            ((OAuth1Signature)this.oAuthSignature.get()).sign((OAuth1Request)new RequestWrapper(request, (MessageBodyWorkers)this.messageBodyWorkers.get()), paramCopy, secretsCopy);
        }
        catch (OAuth1SignatureException se) {
            throw new ProcessingException(LocalizationMessages.ERROR_REQUEST_SIGNATURE(), (Throwable)se);
        }
    }

    private void checkParametersConsistency(OAuth1Parameters oauth1Parameters, OAuth1Secrets oauth1Secrets) {
        if (oauth1Parameters.getSignatureMethod() == null) {
            oauth1Parameters.signatureMethod("HMAC-SHA1");
        }
        if (oauth1Parameters.getVersion() == null) {
            oauth1Parameters.version();
        }
        if (oauth1Secrets.getConsumerSecret() == null || oauth1Parameters.getConsumerKey() == null) {
            throw new ProcessingException(LocalizationMessages.ERROR_CONFIGURATION_MISSING_CONSUMER());
        }
        if (oauth1Parameters.getToken() != null && oauth1Secrets.getTokenSecret() == null) {
            throw new ProcessingException(LocalizationMessages.ERROR_CONFIGURATION_MISSING_TOKEN_SECRET());
        }
    }
}

