
package org.glassfish.jersey.client.oauth1.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.client.oauth1.internal.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableERROR_FLOW_NOT_FINISHED() {
        return MESSAGE_FACTORY.getMessage("error.flow.not.finished");
    }

    /**
     * Authorization is not finished and access token was not received. Call start() and then finish() to perform the authorization.
     * 
     */
    public static String ERROR_FLOW_NOT_FINISHED() {
        return LOCALIZER.localize(localizableERROR_FLOW_NOT_FINISHED());
    }

    public static Localizable localizableERROR_CONFIGURATION_MISSING_CONSUMER() {
        return MESSAGE_FACTORY.getMessage("error.configuration.missing.consumer");
    }

    /**
     * Error occurred in the oauth client support. Consumer secret and consumer key must not be null.
     * 
     */
    public static String ERROR_CONFIGURATION_MISSING_CONSUMER() {
        return LOCALIZER.localize(localizableERROR_CONFIGURATION_MISSING_CONSUMER());
    }

    public static Localizable localizableERROR_REQUEST_SIGNATURE() {
        return MESSAGE_FACTORY.getMessage("error.request.signature");
    }

    /**
     * Error occurred in the oauth client support. Error signing the request.
     * 
     */
    public static String ERROR_REQUEST_SIGNATURE() {
        return LOCALIZER.localize(localizableERROR_REQUEST_SIGNATURE());
    }

    public static Localizable localizableERROR_REQUEST_ACCESS_TOKEN_NULL() {
        return MESSAGE_FACTORY.getMessage("error.request.accessToken.null");
    }

    /**
     * Error occurred in the oauth client support. Returned Access Token is null.
     * 
     */
    public static String ERROR_REQUEST_ACCESS_TOKEN_NULL() {
        return LOCALIZER.localize(localizableERROR_REQUEST_ACCESS_TOKEN_NULL());
    }

    public static Localizable localizableERROR_CONFIGURATION_MISSING_TOKEN_SECRET() {
        return MESSAGE_FACTORY.getMessage("error.configuration.missing.tokenSecret");
    }

    /**
     * Error occurred in the oauth client support. Token is not null but token secret is null.
     * 
     */
    public static String ERROR_CONFIGURATION_MISSING_TOKEN_SECRET() {
        return LOCALIZER.localize(localizableERROR_CONFIGURATION_MISSING_TOKEN_SECRET());
    }

    public static Localizable localizableERROR_REQUEST_REQUEST_TOKEN(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.request.requestToken", arg0);
    }

    /**
     * Error occurred in the oauth client support. Error requesting Request Token. Response status {0} returned.
     * 
     */
    public static String ERROR_REQUEST_REQUEST_TOKEN(Object arg0) {
        return LOCALIZER.localize(localizableERROR_REQUEST_REQUEST_TOKEN(arg0));
    }

    public static Localizable localizableERROR_REQUEST_ACCESS_TOKEN(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.request.accessToken", arg0);
    }

    /**
     * Error occurred in the oauth client support.  Error requesting Access Token. Response status {0} returned.
     * 
     */
    public static String ERROR_REQUEST_ACCESS_TOKEN(Object arg0) {
        return LOCALIZER.localize(localizableERROR_REQUEST_ACCESS_TOKEN(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
