/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

final class NonceManager {
    private final long maxAge;
    private final int gcPeriod;
    private int gcCounter = 0;
    private final TimeUnit timestampUnit;
    private final long maximumMapSize;
    private final SortedMap<Long, Map<String, Set<String>>> tsToKeyNoncePairs = new TreeMap<Long, Map<String, Set<String>>>();
    private volatile long mapSize = 0L;

    public NonceManager(long maxAge, int gcPeriod, TimeUnit timestampUnit, long maximumCacheSize) {
        if (maxAge <= 0L || gcPeriod <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxAge = maxAge;
        this.gcPeriod = gcPeriod;
        this.timestampUnit = timestampUnit;
        this.maximumMapSize = maximumCacheSize;
    }

    synchronized boolean verify(String key, String timestamp, String nonce, long now) {
        boolean result;
        HashSet<String> nonces;
        long stamp = this.timestampUnit.toMillis(NonceManager.longValue(timestamp));
        if (this.mapSize + 1L > this.maximumMapSize) {
            this.gc(now);
            if (this.mapSize + 1L > this.maximumMapSize) {
                return false;
            }
        }
        if (stamp + this.maxAge < now || stamp - this.maxAge > now) {
            return false;
        }
        HashMap<String, HashSet<String>> keyToNonces = (HashMap<String, HashSet<String>>)this.tsToKeyNoncePairs.get(stamp);
        if (keyToNonces == null) {
            keyToNonces = new HashMap<String, HashSet<String>>();
            this.tsToKeyNoncePairs.put(stamp, keyToNonces);
        }
        if ((nonces = (HashSet<String>)keyToNonces.get(key)) == null) {
            nonces = new HashSet<String>();
            keyToNonces.put(key, nonces);
        }
        if (result = nonces.add(nonce)) {
            ++this.mapSize;
        }
        if (++this.gcCounter >= this.gcPeriod) {
            this.gc(now);
        }
        return result;
    }

    public synchronized boolean verify(String key, String timestamp, String nonce) {
        return this.verify(key, timestamp, nonce, System.currentTimeMillis());
    }

    void gc(long now) {
        this.gcCounter = 0;
        SortedMap<Long, Map<String, Set<String>>> headMap = this.tsToKeyNoncePairs.headMap(now - this.maxAge);
        for (Map.Entry<Long, Map<String, Set<String>>> entry : headMap.entrySet()) {
            for (Map.Entry<String, Set<String>> timeEntry : entry.getValue().entrySet()) {
                this.mapSize -= (long)timeEntry.getValue().size();
            }
        }
        headMap.clear();
    }

    long checkAndGetSize() {
        long size = 0L;
        for (Map<String, Set<String>> keyToNonces : this.tsToKeyNoncePairs.values()) {
            size += (long)keyToNonces.values().size();
        }
        assert (this.mapSize == size);
        return this.mapSize;
    }

    private static long longValue(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }
}

