/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

final class NonceManager {
    private final long maxAge;
    private final int gcPeriod;
    private int gcCounter = 0;
    private final SortedMap<Long, Map<String, Set<String>>> tsToKeyNoncePairs = new TreeMap<Long, Map<String, Set<String>>>();

    public NonceManager(long maxAge, int gcPeriod) {
        if (maxAge <= 0L || gcPeriod <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxAge = maxAge;
        this.gcPeriod = gcPeriod;
    }

    public synchronized boolean verify(String key, String timestamp, String nonce) {
        HashSet<String> nonces;
        long now = System.currentTimeMillis();
        long stamp = NonceManager.longValue(timestamp) * 1000L;
        if (stamp + this.maxAge < now) {
            return false;
        }
        HashMap<String, HashSet<String>> keyToNonces = (HashMap<String, HashSet<String>>)this.tsToKeyNoncePairs.get(stamp);
        if (keyToNonces == null) {
            keyToNonces = new HashMap<String, HashSet<String>>();
            this.tsToKeyNoncePairs.put(stamp, keyToNonces);
        }
        if ((nonces = (HashSet<String>)keyToNonces.get(key)) == null) {
            nonces = new HashSet<String>();
            keyToNonces.put(key, nonces);
        }
        boolean result = nonces.add(nonce);
        if (++this.gcCounter >= this.gcPeriod) {
            this.gc(now);
        }
        return result;
    }

    void gc(long now) {
        this.gcCounter = 0;
        this.tsToKeyNoncePairs.headMap(now - this.maxAge).clear();
    }

    long size() {
        long size = 0L;
        for (Map<String, Set<String>> keyToNonces : this.tsToKeyNoncePairs.values()) {
            size += (long)keyToNonces.values().size();
        }
        return size;
    }

    private static long longValue(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }
}

