/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1;

import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Map;
import javax.annotation.Priority;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureFeature;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.oauth1.OAuth1Provider;
import org.glassfish.jersey.server.oauth1.OAuth1ServerFilter;
import org.glassfish.jersey.server.oauth1.OAuth1ServerProperties;
import org.glassfish.jersey.server.oauth1.internal.AccessTokenResource;
import org.glassfish.jersey.server.oauth1.internal.RequestTokenResource;

public class OAuth1ServerFeature
implements Feature {
    private final OAuth1Provider oAuth1Provider;
    private final String requestTokenUri;
    private final String accessTokenUri;

    public OAuth1ServerFeature(OAuth1Provider oAuth1Provider, String requestTokenUri, String accessTokenUri) {
        this.oAuth1Provider = oAuth1Provider;
        this.requestTokenUri = requestTokenUri;
        this.accessTokenUri = accessTokenUri;
    }

    public OAuth1ServerFeature(OAuth1Provider oAuth1Provider) {
        this(oAuth1Provider, null, null);
    }

    public OAuth1ServerFeature() {
        this(null);
    }

    public boolean configure(FeatureContext context) {
        boolean registerResources;
        Map properties;
        Boolean propertyResourceEnabled;
        if (this.oAuth1Provider != null) {
            context.register((Object)this.oAuth1Provider);
        }
        context.register(OAuth1ServerFilter.class);
        if (!context.getConfiguration().isRegistered(OAuth1SignatureFeature.class)) {
            context.register(OAuth1SignatureFeature.class);
        }
        boolean bl = (propertyResourceEnabled = OAuth1ServerProperties.getValue(properties = context.getConfiguration().getProperties(), "jersey.config.server.oauth1.resource.enabled", null, Boolean.class)) != null ? propertyResourceEnabled : (registerResources = this.requestTokenUri != null & this.accessTokenUri != null);
        if (registerResources) {
            String accessUri;
            String requestUri = OAuth1ServerProperties.getValue(properties, "jersey.config.server.oauth1.resource.requestToken.uri", null, String.class);
            if (requestUri == null) {
                String string = requestUri = this.requestTokenUri == null ? "requestToken" : this.requestTokenUri;
            }
            if ((accessUri = OAuth1ServerProperties.getValue(properties, "jersey.config.server.oauth1.resource.accessToken.uri", null, String.class)) == null) {
                accessUri = this.accessTokenUri == null ? "accessToken" : this.accessTokenUri;
            }
            Resource requestResource = Resource.builder(RequestTokenResource.class).path(requestUri).build();
            Resource accessResource = Resource.builder(AccessTokenResource.class).path(accessUri).build();
            context.register((Object)new OAuthModelProcessor(new Resource[]{requestResource, accessResource}));
        }
        return true;
    }

    @Priority(value=100)
    private static class OAuthModelProcessor
    implements ModelProcessor {
        private final Resource[] resources;

        private OAuthModelProcessor(Resource ... resources) {
            this.resources = resources;
        }

        public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
            ResourceModel.Builder builder = new ResourceModel.Builder(resourceModel, false);
            for (Resource resource : this.resources) {
                builder.addResource(resource);
            }
            return builder.build();
        }

        public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
            return subResourceModel;
        }
    }
}

