/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1.internal;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.jersey.oauth1.signature.OAuth1Parameters;
import org.glassfish.jersey.oauth1.signature.OAuth1Request;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;
import org.glassfish.jersey.oauth1.signature.OAuth1Signature;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureException;
import org.glassfish.jersey.server.oauth1.OAuth1Consumer;
import org.glassfish.jersey.server.oauth1.OAuth1Exception;
import org.glassfish.jersey.server.oauth1.OAuth1Provider;
import org.glassfish.jersey.server.oauth1.OAuth1Token;
import org.glassfish.jersey.server.oauth1.TokenResource;
import org.glassfish.jersey.server.oauth1.internal.OAuthServerRequest;

@Path(value="/accessToken")
public class AccessTokenResource {
    @Inject
    private OAuth1Provider provider;
    @Inject
    private OAuth1Signature oAuth1Signature;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/x-www-form-urlencoded"})
    @TokenResource
    public Response postAccessTokenRequest(@Context ContainerRequestContext requestContext, @Context Request req) {
        boolean sigIsOk = false;
        OAuthServerRequest request = new OAuthServerRequest(requestContext);
        OAuth1Parameters params = new OAuth1Parameters();
        params.readRequest((OAuth1Request)request);
        if (params.getToken() == null) {
            throw new WebApplicationException(new Throwable("oauth_token MUST be present."), 400);
        }
        String consKey = params.getConsumerKey();
        if (consKey == null) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        OAuth1Token rt = this.provider.getRequestToken(params.getToken());
        if (rt == null) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        OAuth1Consumer consumer = rt.getConsumer();
        if (consumer == null || !consKey.equals(consumer.getKey())) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        OAuth1Secrets secrets = new OAuth1Secrets().consumerSecret(consumer.getSecret()).tokenSecret(rt.getSecret());
        try {
            sigIsOk = this.oAuth1Signature.verify((OAuth1Request)request, params, secrets);
        }
        catch (OAuth1SignatureException ex) {
            Logger.getLogger(AccessTokenResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!sigIsOk) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        OAuth1Token at = this.provider.newAccessToken(rt, params.getVerifier());
        if (at == null) {
            throw new OAuth1Exception(Response.Status.BAD_REQUEST, null);
        }
        Form resp = new Form();
        resp.param("oauth_token", at.getToken());
        resp.param("oauth_token_secret", at.getSecret());
        resp.asMap().putAll(at.getAttributes());
        return Response.ok((Object)resp).build();
    }
}

