/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.oauth1.signature;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.oauth1.signature.OAuth1Parameters;
import org.glassfish.jersey.oauth1.signature.OAuth1Request;
import org.glassfish.jersey.oauth1.signature.OAuth1Secrets;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureException;
import org.glassfish.jersey.oauth1.signature.OAuth1SignatureMethod;
import org.glassfish.jersey.oauth1.signature.UnsupportedSignatureMethodException;
import org.glassfish.jersey.uri.UriComponent;

public class OAuth1Signature {
    private final HashMap<String, OAuth1SignatureMethod> methods = Maps.newHashMap();

    @Inject
    public OAuth1Signature(ServiceLocator serviceLocator) {
        List methodList = serviceLocator.getAllServices(OAuth1SignatureMethod.class, new Annotation[0]);
        for (OAuth1SignatureMethod oAuth1SignatureMethod : methodList) {
            this.methods.put(oAuth1SignatureMethod.name(), oAuth1SignatureMethod);
        }
    }

    public String generate(OAuth1Request request, OAuth1Parameters params, OAuth1Secrets secrets) throws OAuth1SignatureException {
        return this.getSignatureMethod(params).sign(this.baseString(request, params), secrets);
    }

    public void sign(OAuth1Request request, OAuth1Parameters params, OAuth1Secrets secrets) throws OAuth1SignatureException {
        params = params.clone();
        params.setSignature(this.generate(request, params, secrets));
        params.writeRequest(request);
    }

    public boolean verify(OAuth1Request request, OAuth1Parameters params, OAuth1Secrets secrets) throws OAuth1SignatureException {
        return this.getSignatureMethod(params).verify(this.baseString(request, params), secrets, params.getSignature());
    }

    static String normalizeParameters(OAuth1Request request, OAuth1Parameters params) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (String key : params.keySet()) {
            String value;
            if (key.equals("realm") || key.equals("oauth_signature") || (value = (String)params.get(key)) == null) continue;
            OAuth1Signature.addParam(key, value, list);
        }
        for (String key : request.getParameterNames()) {
            List<String> values;
            if (key.startsWith("oauth_") && params.containsKey(key) || (values = request.getParameterValues(key)) == null) continue;
            for (String value : values) {
                OAuth1Signature.addParam(key, value, list);
            }
        }
        Collections.sort(list, new Comparator<String[]>(){

            @Override
            public int compare(String[] t, String[] t1) {
                int c = t[0].compareTo(t1[0]);
                return c == 0 ? t[1].compareTo(t1[1]) : c;
            }
        });
        StringBuilder buf = new StringBuilder();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String[] param = (String[])i.next();
            buf.append(param[0]).append("=").append(param[1]);
            if (!i.hasNext()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    private URI constructRequestURL(OAuth1Request request) throws OAuth1SignatureException {
        try {
            URL url = request.getRequestURL();
            if (url == null) {
                throw new OAuth1SignatureException();
            }
            StringBuffer buf = new StringBuffer(url.getProtocol()).append("://").append(url.getHost().toLowerCase());
            int port = url.getPort();
            if (port > 0 && port != url.getDefaultPort()) {
                buf.append(':').append(port);
            }
            buf.append(url.getPath());
            return new URI(buf.toString());
        }
        catch (URISyntaxException mue) {
            throw new OAuth1SignatureException(mue);
        }
    }

    private String baseString(OAuth1Request request, OAuth1Parameters params) throws OAuth1SignatureException {
        StringBuilder buf = new StringBuilder(request.getRequestMethod().toUpperCase());
        buf.append('&').append(UriComponent.encode((String)this.constructRequestURL(request).toASCIIString(), (UriComponent.Type)UriComponent.Type.UNRESERVED));
        buf.append('&').append(UriComponent.encode((String)OAuth1Signature.normalizeParameters(request, params), (UriComponent.Type)UriComponent.Type.UNRESERVED));
        return buf.toString();
    }

    private OAuth1SignatureMethod getSignatureMethod(OAuth1Parameters params) throws UnsupportedSignatureMethodException {
        OAuth1SignatureMethod method = this.methods.get(params.getSignatureMethod());
        if (method == null) {
            throw new UnsupportedSignatureMethodException(params.getSignatureMethod());
        }
        return method;
    }

    private static void addParam(String key, String value, List<String[]> list) {
        list.add(new String[]{UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.UNRESERVED), value == null ? "" : UriComponent.encode((String)value, (UriComponent.Type)UriComponent.Type.UNRESERVED)});
    }
}

