/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth2;

import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;

class OAuth2ClientFilter
implements ClientRequestFilter {
    private final String accessToken;

    public OAuth2ClientFilter(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuth2ClientFilter() {
        this.accessToken = null;
    }

    public void filter(ClientRequestContext request) throws IOException {
        String token = this.accessToken;
        String propertyToken = (String)request.getProperty(OAuth2ClientSupport.OAUTH2_PROPERTY_ACCESS_TOKEN);
        if (propertyToken != null) {
            token = propertyToken;
        }
        request.removeProperty(OAuth2ClientSupport.OAUTH2_PROPERTY_ACCESS_TOKEN);
        if (token == null) {
            return;
        }
        String authentication = "Bearer " + token;
        if (!request.getHeaders().containsKey((Object)"Authorization")) {
            request.getHeaders().add((Object)"Authorization", (Object)authentication);
        }
    }
}

