
package org.glassfish.jersey.client.oauth2.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.client.oauth2.internal.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableERROR_FLOW_NOT_FINISHED() {
        return MESSAGE_FACTORY.getMessage("error.flow.not.finished");
    }

    /**
     * Authorization is not finished and access token was not received. Call start() and then finish() to perform the authorization.
     * 
     */
    public static String ERROR_FLOW_NOT_FINISHED() {
        return LOCALIZER.localize(localizableERROR_FLOW_NOT_FINISHED());
    }

    public static Localizable localizableERROR_FLOW_REQUEST_REFRESH_TOKEN(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.flow.request.refreshToken", arg0);
    }

    /**
     * Error refreshing an access token. Response status: {0}.
     * 
     */
    public static String ERROR_FLOW_REQUEST_REFRESH_TOKEN(Object arg0) {
        return LOCALIZER.localize(localizableERROR_FLOW_REQUEST_REFRESH_TOKEN(arg0));
    }

    public static Localizable localizableERROR_FLOW_REQUEST_ACCESS_TOKEN(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.flow.request.accessToken", arg0);
    }

    /**
     * Error requesting access token. Response status {0}.
     * 
     */
    public static String ERROR_FLOW_REQUEST_ACCESS_TOKEN(Object arg0) {
        return LOCALIZER.localize(localizableERROR_FLOW_REQUEST_ACCESS_TOKEN(arg0));
    }

    public static Localizable localizableERROR_FLOW_WRONG_STATE() {
        return MESSAGE_FACTORY.getMessage("error.flow.wrong.state");
    }

    /**
     * Invalid 'state' parameter. 'state' used in the authorization request does not match to the 'state' from the authorization response.
     * 
     */
    public static String ERROR_FLOW_WRONG_STATE() {
        return LOCALIZER.localize(localizableERROR_FLOW_WRONG_STATE());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
