/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.util.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.util.concurrent.MoreExecutors;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.OutboundMessageContext;

final class LoopBackConnector
implements Connector {
    static final int TEST_LOOPBACK_CODE = 600;
    static final Response.StatusType LOOPBACK_STATUS = new Response.StatusType(){

        public int getStatusCode() {
            return 600;
        }

        public Response.Status.Family getFamily() {
            return Response.Status.Family.OTHER;
        }

        public String getReasonPhrase() {
            return "Test connector loop-back";
        }
    };
    private volatile boolean closed = false;

    LoopBackConnector() {
    }

    public ClientResponse apply(ClientRequest request) {
        return this._apply(request);
    }

    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        return MoreExecutors.sameThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.response(LoopBackConnector.this._apply(request));
                }
                catch (Throwable t) {
                    callback.failure(t);
                }
            }
        });
    }

    private ClientResponse _apply(ClientRequest request) {
        this.checkNotClosed();
        ClientResponse response = new ClientResponse(LOOPBACK_STATUS, request);
        response.headers(HeaderUtils.asStringHeaders((MultivaluedMap)request.getHeaders()));
        if (request.hasEntity()) {
            response.setEntityStream((InputStream)new ByteArrayInputStream(this.bufferEntity(request)));
        }
        return response;
    }

    private byte[] bufferEntity(ClientRequest requestContext) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        requestContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){

            public OutputStream getOutputStream(int contentLength) throws IOException {
                return baos;
            }
        });
        try {
            requestContext.writeEntity();
        }
        catch (IOException ioe) {
            throw new ProcessingException("Error buffering the entity.", (Throwable)ioe);
        }
        return baos.toByteArray();
    }

    public String getName() {
        return "test-loop-back-connector";
    }

    public void close() {
        this.closed = true;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Loop-back Connector closed.");
        }
    }
}

