/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.maven.runner;

import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;

public class ShellMojoExecutionException
extends MojoExecutionException {
    private final int errorCode;
    private final Collection<String> lastLines;

    public ShellMojoExecutionException(String message, int errorCode, Collection<String> lastLines) {
        super(String.valueOf(message) + "\nError exit code: " + errorCode + "." + "\nThe last " + lastLines.size() + " lines of stderr/stdout output are: " + "\n" + ShellMojoExecutionException.lastLinesToString(lastLines));
        this.errorCode = errorCode;
        this.lastLines = lastLines;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Collection<String> getLastLines() {
        return this.lastLines;
    }

    private static String lastLinesToString(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        int lineNumber = 1;
        for (String string : collection) {
            sb.append("Line ").append(lineNumber++).append(": ");
            sb.append(string).append("\n");
        }
        return sb.toString();
    }
}

