/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.memleak.common;

import org.glassfish.jersey.test.memleak.common.MemoryLeakUtils;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class MemoryLeakSucceedingTimeout
extends Timeout {
    private static final int DEFAULT_TIMEOUT_MILLIS = 300000;
    private int millis;

    public MemoryLeakSucceedingTimeout() {
        this(300000);
    }

    public MemoryLeakSucceedingTimeout(int defaultMillisTimeout) {
        super(defaultMillisTimeout);
        this.millis = Integer.getInteger("jersey.config.test.memleak.timeout", defaultMillisTimeout);
    }

    public Statement apply(Statement base, Description description) {
        return new FailOnTimeout(base, this.millis){

            public void evaluate() throws Throwable {
                try {
                    super.evaluate();
                }
                catch (Throwable throwable) {
                    if (throwable.getMessage().startsWith("test timed out after")) {
                        MemoryLeakUtils.verifyNoOutOfMemoryOccurred();
                        System.out.println("Test timed out after " + MemoryLeakSucceedingTimeout.this.millis + " ms. Successfully ending.");
                    }
                    throw throwable;
                }
            }
        };
    }
}

