/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.artifacts;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.glassfish.jersey.test.artifacts.MavenUtil;
import org.glassfish.jersey.test.artifacts.TestResult;

class ClassVersionChecker {
    ClassVersionChecker() {
    }

    static TestResult checkClassVersion(JarFile jar, JarEntry entry, Properties properties) throws IOException {
        String jerseyVersion = MavenUtil.getJerseyVersion(properties);
        int minVersion = jerseyVersion.startsWith("3.1") ? 11 : 8;
        return ClassVersionChecker.checkClassVersion(jar.getInputStream(entry), jar.getName() + File.separator + entry.getName(), minVersion);
    }

    private static TestResult checkClassVersion(InputStream inputStream, String filename, int version) throws IOException {
        TestResult result = new TestResult();
        DataInputStream in = new DataInputStream(inputStream);
        int magic = in.readInt();
        if (magic != -889275714) {
            result.exception().append(filename).println(" is not a valid class!");
        }
        int minor = in.readUnsignedShort();
        int major = in.readUnsignedShort();
        int classVersion = ClassVersionChecker.convertMajorMinorToSE(major, minor);
        TestResult.MessageBuilder builder = classVersion <= version ? result.ok() : result.exception();
        builder.append(filename).append(": ").append(major).append(".").append(minor).append(" = JDK ").println(String.valueOf(classVersion));
        in.close();
        return result;
    }

    private static int convertMajorMinorToSE(int major, int minor) {
        int comp = major - 44 + minor;
        return comp;
    }
}

