/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.artifacts;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.glassfish.jersey.test.artifacts.DependencyPair;

public final class MavenUtil {
    static final String JERSEY_VERSION = "jersey.version";
    private static final String PROJECT_VERSION = "project.version";

    static File getArtifactJar(File repositoryRoot, Dependency dependency, Properties properties) {
        return MavenUtil.getArtifactFile(repositoryRoot, dependency, properties, "jar");
    }

    private static File getArtifactFile(File repositoryRoot, Dependency dependency, Properties properties, String extension) {
        String[] artifactIdParts;
        String[] groupIdParts;
        StringBuilder fileSuffix = new StringBuilder();
        for (String groupIdPart : groupIdParts = dependency.getGroupId().split("\\.")) {
            fileSuffix.append(groupIdPart).append(File.separator);
        }
        for (String artifactIdPart : artifactIdParts = dependency.getArtifactId().split("\\.")) {
            fileSuffix.append(artifactIdPart).append(File.separator);
        }
        String version = MavenUtil.getDependencyVersion(dependency, properties);
        fileSuffix.append(version).append(File.separator);
        fileSuffix.append(dependency.getArtifactId()).append('-').append(version).append(".").append(extension);
        return new File(repositoryRoot, fileSuffix.toString());
    }

    static String getDependencyVersion(Dependency dependency, Properties properties) {
        String version = dependency.getVersion();
        if (version.startsWith("${") && version.endsWith("}")) {
            String value;
            String property;
            switch (property = version.substring(2, version.length() - 1)) {
                case "jersey.version": 
                case "project.version": {
                    value = MavenUtil.getJerseyVersion(properties);
                    break;
                }
                default: {
                    value = properties.getProperty(property);
                }
            }
            version = value == null ? version : value;
        }
        return version;
    }

    static File getLocalMavenRepository() {
        String folder = System.getProperty("localRepository");
        return new File(folder);
    }

    static Properties getMavenProperties() {
        try {
            Model model = MavenUtil.getModelFromFile("pom.xml");
            return model.getProperties();
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    static Stream<Dependency> keepJerseyJars(Stream<Dependency> stream, DependencyPair ... keep) {
        return stream.filter(dependency -> {
            for (DependencyPair pair : keep) {
                if (!dependency.getGroupId().equals(pair.groupId()) || !dependency.getArtifactId().equals(pair.artifactId())) continue;
                return true;
            }
            return false;
        });
    }

    static Stream<Dependency> streamJerseyJars() throws IOException, XmlPullParserException {
        Model model = MavenUtil.getModelFromFile("pom.xml");
        List<Dependency> deps = MavenUtil.getBomPomDependencies(model);
        return deps.stream().filter(dep -> dep.getGroupId().startsWith("org.glassfish.jersey")).filter(dep -> dep.getType().equals("jar"));
    }

    static Model getModelFromFile(String fileName) throws IOException, XmlPullParserException {
        File pomFile = new File(fileName);
        return MavenUtil.getModelFromFile(pomFile);
    }

    private static Model getModelFromFile(File file) throws IOException, XmlPullParserException {
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try (FileReader fileReader = new FileReader(file);){
            Model model;
            Model model2 = model = mavenReader.read((Reader)fileReader);
            return model2;
        }
    }

    private static List<Dependency> getBomPomDependencies(Model model) throws IOException, XmlPullParserException {
        Dependency bomPom = null;
        List dependencies = model.getDependencyManagement().getDependencies();
        for (Dependency dependency : dependencies) {
            if (!dependency.getGroupId().equals("org.glassfish.jersey") || !dependency.getArtifactId().equals("jersey-bom")) continue;
            bomPom = dependency;
            break;
        }
        if (bomPom == null) {
            throw new IllegalStateException("Bom pom not found");
        }
        File pom = MavenUtil.getArtifactFile(MavenUtil.getLocalMavenRepository(), bomPom, model.getProperties(), "pom");
        Model bomPomModel = MavenUtil.getModelFromFile(pom);
        return bomPomModel.getDependencyManagement().getDependencies();
    }

    static String getJerseyVersion(Properties properties) {
        String property = properties.getProperty(JERSEY_VERSION);
        if (property == null || property.startsWith("${")) {
            property = System.getProperty(JERSEY_VERSION);
        }
        if (property == null || property.startsWith("${")) {
            throw new IllegalStateException("Property jersey.version not set (-Djersey.version=)");
        }
        return property;
    }

    private static List<Dependency> getProfileDependency(Model model) {
        List profileDependencies = Collections.EMPTY_LIST;
        List profiles = model.getProfiles();
        String activeProfile = MavenUtil.getActiveProfile();
        for (Profile profile : profiles) {
            if (!activeProfile.equals(profile.getId())) continue;
            profileDependencies = profile.getDependencies();
            break;
        }
        return profileDependencies;
    }

    private static String getActiveProfile() {
        String profileId = System.getProperty("profileId");
        return profileId;
    }
}

