/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.artifacts;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

class TestResult {
    private List<String> oks = new LinkedList<String>();
    private List<String> exceptions = new LinkedList<String>();

    TestResult() {
    }

    MessageBuilder ok() {
        return new MessageBuilder(this.oks);
    }

    MessageBuilder exception() {
        return new MessageBuilder(this.exceptions);
    }

    boolean result() {
        for (String ok : this.oks) {
            System.out.append("(pass) ").print(ok);
        }
        for (String exception : this.exceptions) {
            System.out.append("\u001b[31;1m(FAIL) ").append(exception).print("\u001b[0m");
        }
        return this.exceptions.isEmpty();
    }

    public TestResult append(TestResult result) throws IOException {
        this.oks.addAll(result.oks);
        this.exceptions.addAll(result.exceptions);
        return this;
    }

    class MessageBuilder
    implements Appendable {
        final List<String> list;
        final StringBuilder builder = new StringBuilder();

        MessageBuilder(List<String> list) {
            this.list = list;
        }

        @Override
        public MessageBuilder append(CharSequence csq) {
            this.builder.append(csq);
            return this;
        }

        public MessageBuilder append(int i) {
            this.builder.append(i);
            return this;
        }

        @Override
        public MessageBuilder append(CharSequence csq, int start, int end) {
            this.builder.append(csq, start, end);
            return this;
        }

        @Override
        public MessageBuilder append(char c) {
            this.builder.append(c);
            return this;
        }

        public TestResult println(String message) {
            this.builder.append(message).append('\n');
            this.list.add(this.builder.toString());
            return TestResult.this;
        }
    }
}

