/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.tools.plugins;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.glassfish.jersey.tools.plugins.Configuration;
import org.glassfish.jersey.tools.plugins.PredefinedCategories;

@Mojo(name="generate", aggregator=true, defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class GenerateJerseyModuleListMojo
extends AbstractMojo {
    static final String MODULE_NAME_PLACEHOLDER = "%NAME";
    static final String MODULE_DESCRIPTION_PLACEHOLDER = "%DESCRIPTION";
    static final String CATEGORY_CAPTION_PLACEHOLDER = "%CAPTION";
    static final String CATEGORY_GROUP_ID_PLACEHOLDER = "%GROUP_ID";
    static final String CONTENT_PLACEHOLDER = "%CONTENT";
    static final String MODULE_LINK_PATH_PLACEHOLDER = "%LINK_PATH";
    @Parameter(defaultValue="${project.basedir}")
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Parameter(defaultValue="modules.xml")
    private String outputFileName;
    @Parameter
    private String templateFileName;
    @Parameter
    private String tableHeaderFileName;
    @Parameter
    private String tableFooterFileName;
    @Parameter
    private String tableRowFileName;
    @Parameter(defaultValue="false")
    private boolean outputUnmatched;
    private Configuration configuration;
    private Log log;

    public void execute() throws MojoExecutionException {
        try {
            this.configuration = this.prepareParameters();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Plugin initialization failed. Problem reading input files.", (Exception)e);
        }
        ProjectDependencyGraph graph = this.mavenSession.getProjectDependencyGraph();
        List projects = graph.getDownstreamProjects(this.mavenProject, true);
        Map<String, List<MavenProject>> categorizedProjects = this.categorizeModules(projects);
        HashSet<String> allGroups = new HashSet<String>();
        StringBuilder content = new StringBuilder();
        for (PredefinedCategories category : PredefinedCategories.values()) {
            String groupId = category.getGroupId();
            allGroups.add(groupId);
            if (groupId.contains("tests")) continue;
            LinkedList<MavenProject> projectsInCategory = new LinkedList<MavenProject>();
            for (Map.Entry<String, List<MavenProject>> entry : categorizedProjects.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(groupId)) continue;
                allGroups.add(key);
                projectsInCategory.addAll((Collection<MavenProject>)entry.getValue());
            }
            content.append((CharSequence)this.processCategory(category, projectsInCategory));
        }
        LinkedList<MavenProject> unmatched = new LinkedList<MavenProject>();
        for (String groupId : categorizedProjects.keySet()) {
            if (allGroups.contains(groupId)) continue;
            unmatched.addAll((Collection<MavenProject>)categorizedProjects.get(groupId));
        }
        if (unmatched.size() > 0) {
            this.log.warn((CharSequence)("There are unmatched modules (" + unmatched.size() + ")."));
            if (!this.outputUnmatched) {
                this.log.warn((CharSequence)"You can configure the plugin to output unmatched modules by adding <outputUnmatched>true</outputUnmatched> in the configuration.");
            }
        }
        if (this.outputUnmatched) {
            content.append((CharSequence)this.processUnmatched(unmatched));
        }
        try (PrintWriter writer = null;){
            writer = new PrintWriter(this.outputFileName);
            writer.println(this.configuration.getSectionTemplate().replace(CONTENT_PLACEHOLDER, content.toString()));
        }
        this.log.info((CharSequence)("Output written to: " + this.outputFileName));
    }

    private Map<String, List<MavenProject>> categorizeModules(List<MavenProject> projects) {
        HashMap<String, List<MavenProject>> categorizedProjects = new HashMap<String, List<MavenProject>>();
        for (MavenProject project : projects) {
            String groupId = project.getGroupId();
            if (categorizedProjects.containsKey(groupId)) {
                ((List)categorizedProjects.get(groupId)).add(project);
                continue;
            }
            LinkedList<MavenProject> actualList = new LinkedList<MavenProject>();
            actualList.add(project);
            categorizedProjects.put(groupId, actualList);
        }
        return categorizedProjects;
    }

    private StringBuilder processUnmatched(List<MavenProject> unmatchedModules) {
        return this.processModuleList("Other", "other", unmatchedModules);
    }

    private StringBuilder processCategory(PredefinedCategories category, List<MavenProject> projectsInCategory) {
        return this.processModuleList(category.getCaption(), category.getGroupId(), projectsInCategory);
    }

    private StringBuilder processModuleList(String categoryCaption, String categoryId, List<MavenProject> projectsInCategory) {
        StringBuilder categoryContent = new StringBuilder();
        categoryContent.append(this.configuration.getTableHeader().replace(CATEGORY_CAPTION_PLACEHOLDER, categoryCaption).replace(CATEGORY_GROUP_ID_PLACEHOLDER, categoryId));
        Collections.sort(projectsInCategory, new Comparator<MavenProject>(){

            @Override
            public int compare(MavenProject o1, MavenProject o2) {
                return o1.getArtifactId().compareTo(o2.getArtifactId());
            }
        });
        for (MavenProject project : projectsInCategory) {
            if (project.getArtifactId().equals("project")) continue;
            String linkPrefix = this.getLinkPath(project);
            categoryContent.append(this.configuration.getTableRow().replace(MODULE_NAME_PLACEHOLDER, project.getArtifactId()).replace(MODULE_DESCRIPTION_PLACEHOLDER, project.getDescription()).replace(MODULE_LINK_PATH_PLACEHOLDER, linkPrefix + project.getArtifactId()));
        }
        categoryContent.append(this.configuration.getTableFooter());
        return categoryContent;
    }

    private String getLinkPath(MavenProject project) {
        String path = "";
        for (MavenProject parent = project.getParent(); !(parent == null || parent.getArtifactId().equals("project") && parent.getGroupId().equals("org.glassfish.jersey")); parent = parent.getParent()) {
            path = parent.getArtifactId() + "/" + path;
        }
        return path;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public String readFile(String fileName) throws IOException {
        String s;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        StringBuilder sb = new StringBuilder();
        while ((s = reader.readLine()) != null) {
            sb.append(s);
            sb.append("\n");
        }
        reader.close();
        return sb.toString();
    }

    public Configuration prepareParameters() throws IOException {
        Configuration configuration = new Configuration();
        configuration.setSectionTemplate(this.readFile(this.templateFileName));
        configuration.setTableHeader(this.readFile(this.tableHeaderFileName));
        configuration.setTableRow(this.readFile(this.tableRowFileName));
        configuration.setTableFooter(this.readFile(this.tableFooterFileName));
        return configuration;
    }
}

