/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.tools.plugins.releasenotes;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;

@Mojo(name="release-notes", defaultPhase=LifecyclePhase.POST_SITE)
public class ReleaseNotesMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="2.29.1", property="releaseVersion")
    private String releaseVersion;
    @Parameter(required=true, defaultValue="eclipse-ee4j/jersey", property="githubApiUrl")
    private String githubApiUrl;
    @Parameter(property="githubLogin")
    private String githubLogin;
    @Parameter(property="githubToken")
    private String githubToken;
    @Parameter(property="githubPassword")
    private String githubPassword;
    @Parameter(required=true, defaultValue="false", property="publishToGithub")
    private Boolean publishToGithub;
    @Parameter(required=true, defaultValue="true", property="dryRun")
    private Boolean dryRun;
    @Parameter(required=true, property="templateFilePath")
    private String templateFilePath;
    @Parameter(required=true, property="releaseDate")
    private String releaseDate;
    @Parameter(required=true, defaultValue="target/release-notes", property="releaseNotesFilePath")
    private String releaseNotesFilePath;
    private static final String RELEASE_DATE_PATTERN = "@RELEASE_DATE@";
    private static final String LATEST_VERSION_PATTERN = "@LATEST_VERSION@";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateParameters();
        try {
            GitHub github = this.dryRun != false || this.publishToGithub == false ? GitHub.connectAnonymously() : (this.githubPassword != null ? GitHub.connectUsingPassword((String)this.githubLogin, (String)this.githubPassword) : GitHub.connect((String)this.githubLogin, (String)this.githubToken));
            GHRepository repository = github.getRepository(this.githubApiUrl);
            PagedIterable milestones = repository.listMilestones(GHIssueState.ALL);
            for (GHMilestone milestone : milestones) {
                if (!this.releaseVersion.equalsIgnoreCase(milestone.getTitle())) continue;
                this.getLog().info((CharSequence)String.format("Milestone found for release version: %s", this.releaseVersion));
                ReleaseNotesMojo.processMilestone(this.releaseVersion, milestone, repository, this.publishToGithub, this.dryRun, this.templateFilePath, this.releaseDate, this.releaseNotesFilePath, this.getLog());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private static void processMilestone(String releaseVersion, GHMilestone milestone, GHRepository repository, Boolean publishToGithub, Boolean dryRun, String templateFilePath, String releaseDate, String releaseNotesFilePath, Log log) throws MojoExecutionException {
        try {
            String releaseNotes = ReleaseNotesMojo.prepareReleaseNotes(milestone, repository);
            log.info((CharSequence)"Prepared release notes:");
            log.info((CharSequence)releaseNotes);
            if (Boolean.TRUE.equals(publishToGithub) && Boolean.FALSE.equals(dryRun)) {
                log.info((CharSequence)"Publishing release notes to GitHub");
                ReleaseNotesMojo.publishReleaseNotes(releaseNotes, releaseVersion, repository);
            } else {
                log.info((CharSequence)"Publishing to GitHub is disabled, skipping");
            }
            ReleaseNotesMojo.storeReleaseNotes(releaseNotes, templateFilePath, releaseVersion, releaseDate, releaseNotesFilePath, dryRun, log);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private static String prepareReleaseNotes(GHMilestone milestone, GHRepository repository) throws IOException {
        StringBuffer releaseNotes = new StringBuffer();
        String pullRequestFormat = "<li>[<a href='%s'>Pull %d</a>] - %s</li>\n";
        String issueFormat = "<li>[<a href='%s'>Issue %d</a>] - %s</li>\n";
        List issues = repository.getIssues(GHIssueState.CLOSED, milestone);
        issues.stream().map(issue -> String.format(issue.isPullRequest() ? "<li>[<a href='%s'>Pull %d</a>] - %s</li>\n" : "<li>[<a href='%s'>Issue %d</a>] - %s</li>\n", issue.getHtmlUrl(), issue.getNumber(), issue.getTitle())).sorted().forEach(releaseNotes::append);
        return releaseNotes.toString();
    }

    private static void publishReleaseNotes(String releaseNotes, String releaseVersion, GHRepository repository) throws IOException {
        repository.createRelease(releaseVersion).name(releaseVersion).body(releaseNotes).create();
    }

    private static void storeReleaseNotes(String releaseNotes, String templateFilePath, String releaseVersion, String releaseDate, String releaseNotesFilePath, Boolean dryRun, Log log) throws IOException {
        if (Files.notExists(Paths.get(templateFilePath, new String[0]), new LinkOption[0])) {
            log.warn((CharSequence)String.format("There is no source template file at the given location:%s", templateFilePath));
            return;
        }
        ArrayList<String> notesLines = new ArrayList<String>();
        List<String> lines = Files.readAllLines(Paths.get(templateFilePath, new String[0]), Charset.defaultCharset());
        for (String line : lines) {
            if (line.contains(RELEASE_DATE_PATTERN)) {
                notesLines.add(line.replace(RELEASE_DATE_PATTERN, releaseDate));
                continue;
            }
            if (line.contains(LATEST_VERSION_PATTERN)) {
                notesLines.add(line.replace(LATEST_VERSION_PATTERN, releaseVersion));
                continue;
            }
            if (line.contains("<h2>Previous releases</h2>")) {
                notesLines.add("<h2>Pull requests and issues</h2>\n<ul>");
                notesLines.add(releaseNotes);
                notesLines.add("</ul>");
                notesLines.add(line);
                continue;
            }
            if (line.contains("<ul>")) {
                notesLines.add(line);
                notesLines.add(String.format("    <li><a href=\"%s.html\">Jersey %s Release Notes</a></li>", releaseVersion, releaseVersion));
                continue;
            }
            notesLines.add(line);
        }
        if (Boolean.FALSE.equals(dryRun)) {
            log.info((CharSequence)String.format("Storing release notes to file %s/%s.html", releaseNotesFilePath, releaseVersion));
            Files.createDirectories(Paths.get(releaseNotesFilePath, new String[0]), new FileAttribute[0]);
            Files.write(Paths.get(String.format("%s/%s.html", releaseNotesFilePath, releaseVersion), new String[0]), notesLines, Charset.defaultCharset(), new OpenOption[0]);
        } else {
            log.info((CharSequence)"Prepared release notes are not stored to file due to dryRun mode");
            log.info((CharSequence)String.format("File path to store release notes is: %s/%s.html", releaseNotesFilePath, releaseVersion));
        }
    }

    private void validateParameters() throws MojoFailureException {
        if (this.releaseVersion == null) {
            throw new MojoFailureException("releaseVersion shall be provided");
        }
        if (Boolean.FALSE.equals(this.dryRun) || Boolean.TRUE.equals(this.publishToGithub)) {
            if (this.githubLogin == null) {
                throw new MojoFailureException("githubLogin shall be provided");
            }
            if (this.githubPassword == null && this.githubToken == null) {
                throw new MojoFailureException("Either githubPassword or githubToken shall be provided");
            }
        }
    }
}

