/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.connectors.jms.system.MQUrl;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MQAddressList {
    static Logger logger = LogDomains.getLogger(MQAddressList.class, (String)"javax.enterprise.resource.resourceadapter");
    private static String myName = System.getProperty("com.sun.aas.instanceName");
    private List<MQUrl> urlList = new ArrayList<MQUrl>();
    private JmsService jmsService = null;
    private static String nodeAgentHost = null;
    private String targetName = null;

    public MQAddressList() {
        this(null);
    }

    public MQAddressList(JmsService service) {
        this(service, MQAddressList.getServerName());
    }

    public MQAddressList(JmsService service, String targetName) {
        this.logFine(" init" + service + "target " + targetName);
        this.jmsService = service;
        this.targetName = targetName;
    }

    public void setup() throws Exception {
        try {
            if (this.isClustered() && !this.jmsService.getType().equals("REMOTE")) {
                this.logFine("setting up for cluster " + this.targetName);
                this.setupClusterViewFromRepository();
                this.setupForCluster();
            } else {
                this.logFine("setting up for SI/DAS " + this.targetName);
                if (this.isAConfig(this.targetName) || this.isDAS(this.targetName)) {
                    this.logFine("performing default setup for DAS/remote clusters/PE instance" + this.targetName);
                    this.defaultSetup();
                } else {
                    this.logFine("configuring for Standalone EE server instance");
                    this.setupClusterViewFromRepository();
                    this.setupForStandaloneServerInstance();
                }
            }
        }
        catch (ConnectorRuntimeException ce) {
            throw new Exception(ce);
        }
    }

    private void setupClusterViewFromRepository() throws Exception {
        ServerContext context = (ServerContext)Globals.get(ServerContext.class);
        Server server = context.getConfigBean();
        String domainurl = context.getServerConfigURL();
        try {
            nodeAgentHost = this.getNodeAgentHostName(server);
            this.logFine("na host" + nodeAgentHost);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception while attempting to get nodeagentHost", e.getMessage());
            logger.log(Level.FINER, e.getMessage(), e);
        }
    }

    public String getNodeAgentHostName(Server as) throws Exception {
        Domain domain = (Domain)Globals.get(Domain.class);
        NodeAgents nodeAgents = domain.getNodeAgents();
        List nodeAgentsList = nodeAgents.getNodeAgent();
        NodeAgent agent = null;
        for (int i = 0; i < nodeAgentsList.size(); ++i) {
            agent = (NodeAgent)nodeAgentsList.get(i);
            if (agent.getName().equals(as.getNodeAgentRef())) continue;
            agent = null;
        }
        if (agent != null) {
            JmxConnector connector = this.getNodeAgentSystemConnector(agent);
            boolean dasShookHandsWithNodeAgent = Boolean.parseBoolean(agent.getPropertyValue("rendezvousOccurred"));
            if (!dasShookHandsWithNodeAgent) {
                throw new RuntimeException("Error: NA: " + agent.getName() + " has not rendezvous'ed with DAS");
            }
            String naHost = connector.getPropertyValue("client-hostname");
            return naHost;
        }
        return null;
    }

    public JmxConnector getNodeAgentSystemConnector(NodeAgent controller) throws Exception {
        String systemConnectorName = controller.getSystemJmxConnectorName();
        JmxConnector connector = controller.getJmxConnector();
        if (connector == null) {
            throw new Exception("Node Agent controller.getName() does not have a system connector named systemConnectorName");
        }
        return connector;
    }

    public String getMasterBroker(String clustername) {
        String masterbrk = null;
        try {
            JmsHost mb = this.getMasterJmsHostInCluster(clustername);
            JmsService js = this.getJmsServiceForMasterBroker(clustername);
            MQUrl url = MQAddressList.createUrl(mb, js);
            masterbrk = url.toString();
            logger.log(Level.FINE, "Master broker obtained is " + masterbrk);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot obtain master broker");
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return masterbrk;
    }

    private JmsService getJmsServiceForMasterBroker(String clusterName) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        List clusterList = clusters.getCluster();
        Cluster cluster = null;
        for (int i = 0; i < clusterList.size(); ++i) {
            if (!clusterName.equals(((Cluster)clusterList.get(i)).getName())) continue;
            cluster = (Cluster)clusterList.get(i);
        }
        Server[] buddies = this.getServersInCluster(cluster);
        Config cfg = this.getConfigForServer(buddies[0]);
        return cfg.getJmsService();
    }

    private Config getConfigForServer(Server server) {
        String cfgRef = server.getConfigRef();
        return this.getConfigByName(cfgRef);
    }

    private Config getConfigByName(String cfgRef) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Configs configs = domain.getConfigs();
        List configList = configs.getConfig();
        for (int i = 0; i < configList.size(); ++i) {
            Config config = (Config)configList.get(i);
            if (!config.getName().equals(cfgRef)) continue;
            return config;
        }
        return null;
    }

    private JmsHost getMasterJmsHostInCluster(String clusterName) throws Exception {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        List clustersList = clusters.getCluster();
        Server[] buddies = null;
        for (int i = 0; i < clustersList.size(); ++i) {
            if (!clusterName.equals(((Cluster)clustersList.get(i)).getName())) continue;
            buddies = this.getServersInCluster((Cluster)clustersList.get(i));
        }
        for (void var9_10 : buddies) {
            try {
                JmsHost copy = this.getResolvedJmsHost((Server)var9_10);
                return copy;
            }
            catch (Exception e) {
            }
        }
        throw new RuntimeException("No JMS hosts available to select as Master");
    }

    private Server[] getServersInCluster(Cluster cluster) {
        List serverRefs = cluster.getServerRef();
        Server[] result = new Server[serverRefs.size()];
        Domain domain = (Domain)Globals.get(Domain.class);
        for (int i = 0; i < serverRefs.size(); ++i) {
            result[i] = domain.getServerNamed(((ServerRef)serverRefs.get(i)).getRef());
        }
        return result;
    }

    private boolean isDAS(String targetName) {
        return !this.isAConfig(targetName);
    }

    private boolean isAConfig(String targetName) {
        Config config = this.getConfigByName(targetName);
        return config != null;
    }

    private void setupForStandaloneServerInstance() throws Exception {
        if (this.jmsService.getType().equals("REMOTE")) {
            this.logFine("REMOTE Standalone server instance and hence use default setup");
            this.defaultSetup();
        } else {
            this.logFine("LOCAL/EMBEDDED Standalone server instance");
            JmsHost host = this.getResolvedJmsHostForStandaloneServerInstance(this.targetName);
            MQUrl url = this.createUrl(host);
            this.urlList.add(url);
        }
    }

    private void defaultSetup() throws Exception {
        this.logFine("performing defaultsetup");
        JmsService jmsService = (JmsService)Globals.get(JmsService.class);
        List hosts = jmsService.getJmsHost();
        for (int i = 0; i < hosts.size(); ++i) {
            MQUrl url = this.createUrl((JmsHost)hosts.get(i));
            this.urlList.add(url);
        }
    }

    private void setupForCluster() throws Exception {
        Map<String, JmsHost> hostMap = this.getResolvedLocalJmsHostsInMyCluster(true);
        JmsHost jmsHost = hostMap.get(myName);
        MQUrl myUrl = this.createUrl(jmsHost, nodeAgentHost);
        this.urlList.add(myUrl);
        hostMap.remove(myName);
        for (JmsHost host : hostMap.values()) {
            MQUrl url = this.createUrl(host);
            this.urlList.add(url);
        }
    }

    public Map<String, JmsHost> getResolvedLocalJmsHostsInMyCluster(boolean includeMe) {
        HashMap<String, JmsHost> map = new HashMap<String, JmsHost>();
        Cluster cluster = this.getClusterForServer(myName);
        if (cluster != null) {
            Server[] buddies;
            for (Server as : buddies = this.getServersInCluster(cluster)) {
                if (!includeMe && myName.equals(as.getName())) continue;
                try {
                    JmsHost copy = this.getResolvedJmsHost(as);
                    map.put(as.getName(), copy);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    private Cluster getClusterForServer(String instanceName) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        List clusterList = clusters.getCluster();
        for (int i = 0; i < clusterList.size(); ++i) {
            Cluster cluster = (Cluster)clusterList.get(i);
            if (!this.isServerInCluster(cluster, instanceName)) continue;
            return cluster;
        }
        return null;
    }

    private boolean isServerInCluster(Cluster cluster, String instanceName) {
        List serverRef = cluster.getServerRef();
        for (int i = 0; i < serverRef.size(); ++i) {
            if (!instanceName.equals(serverRef.get(i))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "";
        Iterator<MQUrl> it = this.urlList.iterator();
        if (it.hasNext()) {
            s = ((Object)it.next()).toString();
        }
        while (it.hasNext()) {
            s = s + "," + ((Object)it.next()).toString();
        }
        this.logFine("toString returns :: " + s);
        return s;
    }

    public void addMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.add(url);
    }

    public void removeMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.remove(url);
    }

    public void updateMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.remove(url);
        this.urlList.add(url);
    }

    private MQUrl createUrl(JmsHost host) {
        return MQAddressList.createUrl(host, this.jmsService);
    }

    private MQUrl createUrl(JmsHost host, String overridedHostName) {
        return MQAddressList.createUrl(host, this.jmsService, overridedHostName);
    }

    public static MQUrl createUrl(JmsHost host, JmsService js) {
        return MQAddressList.createUrl(host, js, null);
    }

    public static MQUrl createUrl(JmsHost host, JmsService js, String overridedHostName) {
        try {
            String name = host.getName();
            String hostName = host.getHost();
            ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
            Server server = serverContext.getConfigBean();
            if (overridedHostName != null && !overridedHostName.trim().equals("")) {
                hostName = overridedHostName;
            }
            String port = host.getPort();
            MQUrl url = new MQUrl(name);
            url.setHost(hostName);
            url.setPort(port);
            if (js != null) {
                String service;
                String scheme = js.getMqScheme();
                if (scheme != null && !scheme.trim().equals("")) {
                    url.setScheme(scheme);
                }
                if ((service = js.getMqService()) != null && !service.trim().equals("")) {
                    url.setService(service);
                }
            }
            return url;
        }
        catch (Exception ce) {
            ce.printStackTrace();
            return null;
        }
    }

    private JmsHost getResolvedJmsHostForStandaloneServerInstance(String serverName) throws Exception {
        this.logFine(" getresolved " + serverName);
        Server serverInstance = this.getServerByName(serverName);
        this.logFine("serverinstace " + serverInstance);
        JmsHost jmsHost = this.getResolvedJmsHost(serverInstance);
        return jmsHost;
    }

    private Server getServerByName(String serverName) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Servers servers = domain.getServers();
        List serverList = servers.getServer();
        for (int i = 0; i < serverList.size(); ++i) {
            Server server = (Server)serverList.get(i);
            if (!serverName.equals(server.getName())) continue;
            return server;
        }
        return null;
    }

    private JmsHost getResolvedJmsHost(Server as) throws Exception {
        this.logFine("getResolvedJmsHost " + as);
        return null;
    }

    private boolean isClustered() throws ConnectorRuntimeException {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        if (clusters == null) {
            return false;
        }
        List clusterList = clusters.getCluster();
        return JmsRaUtil.isClustered(clusterList, myName);
    }

    private static String getServerName() {
        String serverName = System.getProperty("com.sun.aas.instanceName");
        return serverName;
    }

    private void logFine(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "MQAddressList :: " + s);
        }
    }

    public int getSize() {
        if (this.urlList != null) {
            return this.urlList.size();
        }
        return 0;
    }
}

