/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class JMSConfigListener
implements ConfigListener {
    @Inject
    private JmsService jmsservice;
    private ActiveJmsResourceAdapter aresourceAdapter;
    private static final Logger _logger = LogDomains.getLogger(JMSConfigListener.class, (String)"javax.enterprise.resource.jms");
    private static StringManager sm = StringManager.getManager(JMSConfigListener.class);

    public void setActiveResourceAdapter(ActiveJmsResourceAdapter aresourceAdapter) {
        this.aresourceAdapter = aresourceAdapter;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        Domain domain = (Domain)Globals.get(Domain.class);
        _logger.log(Level.FINE, "In JMSConfigListener - recived config event");
        for (PropertyChangeEvent event : events) {
            String eventName = event.getPropertyName();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            _logger.log(Level.FINE, "In JMSConfigListener " + eventName + oldValue + newValue);
            boolean accepted = true;
            if (oldValue != null && oldValue.equals(newValue)) {
                _logger.log(Level.FINE, "Event " + eventName + " did not change existing value of " + oldValue);
                continue;
            }
            if (event.getSource() instanceof JmsService && eventName.equals("master-broker")) {
                String oldMB = oldValue.toString();
                String newMB = newValue.toString();
                _logger.log(Level.FINE, "Got JmsService Master Broker change event " + event.getSource() + " " + eventName + " " + oldMB + " " + newMB);
                Server newMBServer = domain.getServerNamed(newMB);
                if (newMBServer != null) {
                    Node node = domain.getNodeNamed(newMBServer.getNode());
                    String newMasterBrokerPort = JmsRaUtil.getJMSPropertyValue(newMBServer);
                    if (newMasterBrokerPort == null) {
                        newMasterBrokerPort = this.getDefaultJmsHost(this.jmsservice).getPort();
                    }
                    String newMasterBrokerHost = node.getNodeHost();
                    this.aresourceAdapter.setMasterBroker(newMasterBrokerHost + ":" + newMasterBrokerPort);
                }
            }
            if (!(event.getSource() instanceof Cluster)) continue;
            _logger.log(Level.FINE, "In JMSConfigListener - recieved cluster event " + event.getSource());
            ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
            Server server = domain.getServerNamed(serverContext.getInstanceName());
            if (server != null) {
                Cluster changedCluster = (Cluster)event.getSource();
                Cluster thisCluster = server.getCluster();
                if (!changedCluster.getName().equals(thisCluster.getName())) {
                    _logger.log(Level.FINE, "Got Cluster change event but ignoring the change since it does not pertain to this cluster" + event.getSource() + " " + eventName + " Changed Cluster: " + changedCluster.getName() + " this Cluster: " + thisCluster.getName());
                    continue;
                }
            }
            if (!eventName.equals("server-ref")) continue;
            String oldServerRef = oldValue.toString();
            String newServerRef = newValue.toString();
            _logger.log(Level.FINE, "Got Cluster change event for server_ref" + event.getSource() + " " + eventName + " " + oldServerRef + " " + newServerRef);
        }
        return null;
    }

    private JmsHost getDefaultJmsHost(JmsService jmsService) {
        JmsHost jmsHost = null;
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        List jmsHostsList = jmsService.getJmsHost();
        for (int i = 0; i < jmsHostsList.size(); ++i) {
            JmsHost tmpJmsHost = (JmsHost)jmsHostsList.get(i);
            if (tmpJmsHost == null || !tmpJmsHost.getName().equals(defaultJmsHostName)) continue;
            jmsHost = tmpJmsHost;
        }
        return jmsHost;
    }
}

