/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2008-2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.admin.cli;

import java.util.*;
import org.jvnet.hk2.annotations.*;
import org.jvnet.hk2.component.*;
import org.glassfish.api.Param;
import org.glassfish.api.admin.*;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;

/**
 * A local export command.
 *  
 * @author Bill Shannon
 */
@Service(name = "export")
@Scoped(PerLookup.class)
public class ExportCommand extends CLICommand {

    private static final LocalStringsImpl strings =
            new LocalStringsImpl(ExportCommand.class);

    @Param(name = "environment-variable", primary = true, optional = true,
	    multiple = true)
    private List<String> vars;

    @Override
    public int executeCommand()
            throws CommandException, CommandValidationException {
        int ret = 0;    // by default, success

        // if no operands, print out everything
        if (vars == null || vars.size() == 0) {
            for (Map.Entry<String, String> e : env.entrySet())
                logger.info(e.getKey() + " = " + quote(e.getValue()));
        } else {
            // otherwise, process each operand
            for (String arg : vars) {
                // separate into name and value
                String name, value;
                int eq = arg.indexOf('=');
                if (eq < 0) {   // no value
                    name = arg;
                    value = null;
                } else {
                    name = arg.substring(0, eq);
                    value = arg.substring(eq + 1);
                }

                // check that name is legitimate
                if (!name.startsWith(Environment.PREFIX)) {
                    logger.info(strings.get("badEnvVarSet", name, Environment.PREFIX));
                    ret = -1;
                    continue;
                }

                // if no value, print it, otherwise set it
                if (value == null) {
                    String v = env.get(name);
                    if (v != null)
                        logger.info(name + " = " + v);
                } else
                    env.put(name, value);
            }
        }
        return ret;
    }
}
