/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.ArgumentTokenizer;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service(name="multimode")
@PerLookup
public class MultimodeCommand
extends CLICommand {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private CLIContainer container;
    @Param(optional=true, shortName="f")
    private File file;
    @Param(name="printprompt", optional=true)
    private Boolean printPromptOpt;
    private boolean printPrompt;
    @Param(optional=true)
    private String encoding;
    private boolean echo;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MultimodeCommand.class);

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.printPrompt = this.printPromptOpt != null ? this.printPromptOpt.booleanValue() : this.programOpts.isInteractive();
        this.echo = this.programOpts.isEcho();
    }

    @Override
    protected Collection<CommandModel.ParamModel> usageOptions() {
        Collection opts = this.commandModel.getParameters();
        LinkedHashSet<CommandModel.ParamModel> uopts = new LinkedHashSet<CommandModel.ParamModel>();
        CommandModelData.ParamModelData p = new CommandModelData.ParamModelData("printprompt", Boolean.TYPE, true, Boolean.toString(this.programOpts.isInteractive()));
        for (CommandModel.ParamModel pm : opts) {
            if (pm.getName().equals("printprompt")) {
                uopts.add((CommandModel.ParamModel)p);
                continue;
            }
            uopts.add(pm);
        }
        return uopts;
    }

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        BufferedReader reader = null;
        this.programOpts.setEcho(this.echo);
        try {
            if (this.file == null) {
                System.out.println(strings.get("multimodeIntro"));
                if (this.encoding != null) {
                    reader = new BufferedReader(new InputStreamReader(System.in, this.encoding));
                }
                reader = new BufferedReader(new InputStreamReader(System.in));
            } else {
                this.printPrompt = false;
                if (!this.file.canRead()) {
                    throw new CommandException("File: " + String.valueOf(this.file) + " can not be read");
                }
                reader = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding)) : new BufferedReader(new FileReader(this.file));
            }
            int n = this.executeCommands(reader);
            return n;
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            try {
                if (this.file != null && reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void atomicReplace(ServiceLocator locator, ProgramOptions options) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter((Filter)BuilderHelper.createContractFilter((String)ProgramOptions.class.getName()));
        AbstractActiveDescriptor desc = BuilderHelper.createConstantDescriptor((Object)options, null, (Type[])new Type[]{ProgramOptions.class});
        config.addActiveDescriptor((ActiveDescriptor)desc);
        config.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommands(BufferedReader reader) throws CommandException, CommandValidationException, IOException {
        int rc = 0;
        this.programOpts.toEnvironment(this.env);
        String prompt = this.programOpts.getCommandName() + "> ";
        while (true) {
            String command;
            String[] args;
            String line;
            if (this.printPrompt) {
                System.out.print(prompt);
                System.out.flush();
            }
            if ((line = reader.readLine()) == null) {
                if (!this.printPrompt) break;
                System.out.println();
                break;
            }
            if (line.trim().startsWith("#")) continue;
            try {
                args = this.getArgs(line);
            }
            catch (ArgumentTokenizer.ArgumentException ex) {
                logger.info(ex.getMessage());
                continue;
            }
            if (args.length == 0 || (command = args[0]).length() == 0) continue;
            if (command.equals("exit") || command.equals("quit")) break;
            CLICommand cmd = null;
            ProgramOptions po = null;
            try {
                po = new ProgramOptions(this.env);
                po.setClassPath(this.programOpts.getClassPath());
                po.setClassName(this.programOpts.getClassName());
                po.setCommandName(this.programOpts.getCommandName());
                MultimodeCommand.atomicReplace(this.habitat, po);
                cmd = CLICommand.getCommand(this.habitat, command);
                rc = cmd.execute(args);
            }
            catch (CommandValidationException cve) {
                logger.severe(cve.getMessage());
                if (cmd != null) {
                    logger.severe(cmd.getUsage());
                }
                rc = 1;
            }
            catch (InvalidCommandException ice) {
                logger.severe(ice.getMessage());
                try {
                    if (po != null) {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getAllCommands(this.container, po, this.env), strings.get("ClosestMatchedLocalAndRemoteCommands"), logger);
                    }
                }
                catch (InvalidCommandException invalidCommandException) {
                    // empty catch block
                }
                rc = 1;
            }
            catch (CommandException ce) {
                if (ce.getCause() instanceof ConnectException) {
                    logger.severe(ce.getMessage());
                    try {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getLocalCommands(this.container), strings.get("ClosestMatchedLocalCommands"), logger);
                    }
                    catch (InvalidCommandException e) {
                        logger.info(strings.get("InvalidRemoteCommand", new Object[]{command}));
                    }
                } else {
                    logger.severe(ce.getMessage());
                }
                rc = 1;
            }
            finally {
                MultimodeCommand.atomicReplace(this.habitat, this.programOpts);
            }
            switch (rc) {
                case 0: {
                    if (this.programOpts.isTerse()) break;
                    logger.fine(strings.get("CommandSuccessful", new Object[]{command}));
                    break;
                }
                default: {
                    logger.fine(strings.get("CommandUnSuccessful", new Object[]{command}));
                }
            }
            CLIUtil.writeCommandToDebugLog(this.programOpts.getCommandName() + "[multimode]", this.env, args, rc);
        }
        return rc;
    }

    private String[] getArgs(String line) throws ArgumentTokenizer.ArgumentException {
        ArrayList<String> args = new ArrayList<String>();
        ArgumentTokenizer t = new ArgumentTokenizer(line);
        while (t.hasMoreTokens()) {
            args.add(t.nextToken());
        }
        return args.toArray(new String[args.size()]);
    }
}

