/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.ClientCookieStore;
import com.sun.enterprise.admin.cli.remote.DetachListener;
import com.sun.enterprise.admin.cli.remote.ProgressStatusPrinter;
import com.sun.enterprise.admin.cli.remote.ReExecuted;
import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.security.store.AsadminSecurityUtil;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.StringUtils;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.ManPageFinder;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.component.MultiMap;

public class RemoteCLICommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteCLICommand.class);
    private boolean returnOutput = false;
    private String output;
    private boolean returnActionReport = false;
    private ActionReport ar;
    private String usage;
    private String responseFormatType;
    private OutputStream userOut;
    private File outputDir;
    protected ParameterMap reExecutedOptions;
    protected List<String> reExecutedOperands;
    private CLIRemoteAdminCommand rac;
    private final MultiMap<String, AdminCommandEventBroker.AdminCommandListener<GfSseInboundEvent>> listeners = new MultiMap();
    private static ClassLoader moduleClassLoader;
    private static ServiceLocator manServiceLocator;

    public RemoteCLICommand() throws CommandException {
    }

    public RemoteCLICommand(String name, ProgramOptions po, Environment env) throws CommandException {
        super(name, po, env);
    }

    public RemoteCLICommand(String name, ProgramOptions po, Environment env, String responseFormatType, OutputStream userOut) throws CommandException {
        this(name, po, env);
        this.responseFormatType = responseFormatType;
        this.userOut = userOut;
    }

    private void reExecuteAfterMetadataUpdate() throws ReExecuted, CommandException {
        if (this.rac == null) {
            return;
        }
        if (this.rac.getCommandModel() == null) {
            return;
        }
        if (!this.rac.isCommandModelFromCache()) {
            return;
        }
        String eTag = CachedCommandModel.computeETag((CommandModel)this.rac.getCommandModel());
        this.rac = null;
        this.initializeRemoteAdminCommand();
        this.rac.fetchCommandModel();
        String newETag = CachedCommandModel.computeETag((CommandModel)this.rac.getCommandModel());
        if (eTag != null && eTag.equals(newETag)) {
            return;
        }
        this.reExecutedOptions = this.options;
        this.reExecutedOperands = this.operands;
        this.options = null;
        this.operands = null;
        int result = this.execute(this.argv);
        throw new ReExecuted(result);
    }

    @Override
    public int execute(String ... argv) throws CommandException {
        try {
            logger.log(Level.FINEST, "RemoteCLICommand executes");
            return super.execute(argv);
        }
        catch (ReExecuted reex) {
            return reex.getExecutionResult();
        }
    }

    public void setFileOutputDirectory(File dir) {
        this.outputDir = dir;
    }

    @Override
    protected void prepare() throws CommandException, CommandValidationException {
        try {
            this.processProgramOptions();
            this.initializeAuth();
            this.initializeRemoteAdminCommand();
            if (this.responseFormatType != null) {
                this.rac.setResponseFormatType(this.responseFormatType);
            }
            if (this.userOut != null) {
                this.rac.setUserOut(this.userOut);
            }
            this.initializeCookieManager();
            if (this.programOpts.isHelp()) {
                CommandModelData cm = new CommandModelData(this.name);
                cm.add((CommandModel.ParamModel)new CommandModelData.ParamModelData("help", Boolean.TYPE, true, "false", "?"));
                this.commandModel = cm;
                this.rac.setCommandModel((CommandModel)cm);
                return;
            }
            this.commandModel = this.rac.getCommandModel();
        }
        catch (CommandException e) {
            logger.log(Level.SEVERE, "RemoteCLICommand.prepare throws exception.", e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "RemoteCLICommand.prepare throws exception.", e);
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void prevalidate() throws CommandException {
        try {
            Object operandModel;
            if (this.reExecutedOperands != null && !this.reExecutedOperands.isEmpty() && (operandModel = this.getOperandModel()) != null && !operandModel.getParam().optional()) {
                if (this.operands == null) {
                    this.operands = new ArrayList(this.reExecutedOperands.size());
                }
                if (this.reExecutedOperands.size() > this.operands.size()) {
                    if (operandModel.getParam().multiple()) {
                        for (String str : this.reExecutedOperands) {
                            if (this.operands.contains(str)) continue;
                            this.operands.add(str);
                        }
                    } else if (this.reExecutedOperands.size() == 1) {
                        this.operands = this.reExecutedOperands;
                    }
                }
            }
            if (this.reExecutedOptions != null) {
                for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
                    if (opt.getParam().primary() || this.options.get((Object)opt.getName()) != null || this.reExecutedOptions.get((Object)opt.getName()) == null) continue;
                    this.options.set((Object)opt.getName(), (Collection)this.reExecutedOptions.get((Object)opt.getName()));
                }
            }
            super.prevalidate();
        }
        catch (CommandException ex) {
            this.reExecuteAfterMetadataUpdate();
            throw ex;
        }
    }

    @Override
    protected void parse() throws CommandException {
        try {
            super.parse();
        }
        catch (CommandValidationException ex) {
            this.reExecuteAfterMetadataUpdate();
            throw ex;
        }
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        if (this.programOpts.isHelp()) {
            return;
        }
        try {
            super.validate();
        }
        catch (CommandValidationException ex) {
            this.reExecuteAfterMetadataUpdate();
            throw ex;
        }
    }

    @Override
    protected void inject() throws CommandException {
        try {
            super.prevalidate();
        }
        catch (CommandValidationException ex) {
            this.reExecuteAfterMetadataUpdate();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            logger.finer("RemoteCLICommand.executeCommand()");
            this.rac.statusPrinter.reset();
            this.options.set((Object)"DEFAULT", (Collection)this.operands);
            if (this.programOpts.isDetachedCommand()) {
                this.rac.registerListener("AdminCommandInstance/stateChanged", new DetachListener(logger, this.rac, this.programOpts.isTerse()));
            }
            try {
                this.output = this.rac.executeCommand(this.options);
            }
            finally {
                this.rac.statusPrinter.deleteLastMessage();
            }
            this.ar = this.rac.getActionReport();
            if (!(this.returnActionReport || this.returnOutput || this.output.isEmpty())) {
                logger.info(this.output);
            }
        }
        catch (CommandValidationException cve) {
            this.reExecuteAfterMetadataUpdate();
            throw cve;
        }
        catch (CommandException ex) {
            if (this.programOpts.isHelp()) {
                BufferedReader r = this.getLocalManPage();
                BufferedReader br = null;
                try {
                    if (r != null) {
                        int cnt;
                        br = new BufferedReader(r);
                        PrintWriter pw = new PrintWriter(System.out);
                        char[] buf = new char[8192];
                        while ((cnt = br.read(buf)) > 0) {
                            pw.write(buf, 0, cnt);
                        }
                        pw.flush();
                        int n = 0;
                        return n;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            throw ex;
        }
        ActionReport ar = this.rac.getActionReport();
        if (ar != null && ActionReport.ExitCode.WARNING == ar.getActionExitCode()) {
            return 4;
        }
        return 0;
    }

    public String executeAndReturnOutput(String ... args) throws CommandException, CommandValidationException {
        this.returnOutput = true;
        this.execute(args);
        this.returnOutput = false;
        return this.output;
    }

    public ActionReport executeAndReturnActionReport(String ... args) throws CommandException, CommandValidationException {
        this.returnActionReport = true;
        this.execute(args);
        this.returnActionReport = false;
        return this.ar;
    }

    @Override
    public String getUsage() {
        if (this.usage == null) {
            if (this.rac == null) {
                return this.getCommandUsage();
            }
            this.usage = this.rac.getUsage();
        }
        if (this.usage == null) {
            return super.getUsage();
        }
        StringBuilder usageText = new StringBuilder();
        usageText.append(strings.get("Usage", new Object[]{this.getBriefCommandUsage()}));
        usageText.append(" ");
        usageText.append(this.usage);
        return usageText.toString();
    }

    @Override
    public BufferedReader getManPage() {
        try {
            this.initializeRemoteAdminCommand();
            String manpage = this.rac.getManPage();
            return new BufferedReader(new StringReader(manpage));
        }
        catch (CommandException manpage) {
            BufferedReader r = this.getLocalManPage();
            return r != null ? r : super.getManPage();
        }
    }

    public synchronized void registerListener(String regexpForName, AdminCommandEventBroker.AdminCommandListener listener) {
        this.listeners.add((Object)regexpForName, (Object)listener);
        if (this.rac != null) {
            this.rac.registerListener(regexpForName, listener);
        }
    }

    private BufferedReader getLocalManPage() {
        logger.fine(strings.get("NoRemoteManPage"));
        String cmdClass = RemoteCLICommand.getCommandClass(this.getName());
        ClassLoader mcl = RemoteCLICommand.getModuleClassLoader();
        if (cmdClass != null && mcl != null) {
            return ManPageFinder.getCommandManPage((String)this.getName(), (String)cmdClass, (Locale)Locale.getDefault(), (ClassLoader)mcl, (Logger)logger);
        }
        return null;
    }

    private void initializeRemoteAdminCommand() throws CommandException {
        if (this.rac == null) {
            this.rac = new CLIRemoteAdminCommand(this.name, this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure(), this.programOpts.getUser(), this.programOpts.getPassword(), logger, this.programOpts.getAuthToken(), this.programOpts.isNotifyCommand());
            this.rac.setFileOutputDirectory(this.outputDir);
            this.rac.setInteractive(this.programOpts.isInteractive());
            for (String key : this.listeners.keySet()) {
                for (AdminCommandEventBroker.AdminCommandListener listener : this.listeners.get((Object)key)) {
                    this.rac.registerListener(key, listener);
                }
            }
        }
    }

    private void initializeAuth() throws CommandException {
        LoginInfo li = null;
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
            li = store.read(this.programOpts.getHost(), this.programOpts.getPort());
            if (li == null) {
                return;
            }
        }
        catch (StoreException se) {
            logger.finer("Login info could not be read from ~/.asadminpass file");
            return;
        }
        if (this.programOpts.getUser() == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Getting user name from ~/.asadminpass: " + li.getUser());
            }
            this.programOpts.setUser(li.getUser());
            if (this.programOpts.getPassword() == null) {
                logger.finer("Getting password from ~/.asadminpass");
                this.programOpts.setPassword(li.getPassword(), ProgramOptions.PasswordLocation.LOGIN_FILE);
            }
        } else if (this.programOpts.getUser().equals(li.getUser()) && this.programOpts.getPassword() == null) {
            logger.finer("Getting password from ~/.asadminpass");
            this.programOpts.setPassword(li.getPassword(), ProgramOptions.PasswordLocation.LOGIN_FILE);
        }
    }

    private void initializeCookieManager() {
        CookieStore defaultCookieStore = new CookieManager().getCookieStore();
        CookieManager manager = new CookieManager(defaultCookieStore, CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(manager);
    }

    private static String getCommandClass(String cmdName) {
        String cname;
        ServiceLocator h = RemoteCLICommand.getManHabitat();
        ActiveDescriptor ad = h.getBestDescriptor((Filter)BuilderHelper.createNameAndContractFilter((String)(cname = "org.glassfish.api.admin.AdminCommand"), (String)cmdName));
        if (ad == null) {
            return null;
        }
        return ad.getImplementation();
    }

    private static synchronized ServiceLocator getManHabitat() {
        if (manServiceLocator != null) {
            return manServiceLocator;
        }
        StaticModulesRegistry registry = new StaticModulesRegistry(RemoteCLICommand.getModuleClassLoader());
        manServiceLocator = registry.createServiceLocator("default");
        return manServiceLocator;
    }

    private static synchronized ClassLoader getModuleClassLoader() {
        if (moduleClassLoader != null) {
            return moduleClassLoader;
        }
        File installDir = new File(System.getProperty("com.sun.aas.installRoot"));
        File modulesDir = new File(installDir, "modules");
        moduleClassLoader = new DirectoryClassLoader(modulesDir, CLICommand.class.getClassLoader());
        return moduleClassLoader;
    }

    private class CLIRemoteAdminCommand
    extends RemoteRestAdminCommand {
        private static final String JSESSIONID = "JSESSIONID";
        private static final String COOKIE_HEADER = "Cookie";
        private CookieManager cookieManager;
        private final File sessionCache;
        private final ProgressStatusPrinter statusPrinter;

        public CLIRemoteAdminCommand(String name, String host, int port, boolean secure, String user, char[] password, Logger logger, String authToken, boolean notify) throws CommandException {
            String stimeout;
            super(name, host, port, secure, user, password, logger, CLICommand.getCommandScope(), authToken, true, notify);
            if (RemoteCLICommand.this.programOpts.getCommandName() != null && RemoteCLICommand.this.programOpts.getCommandName().contains("cadmin")) {
                super.setEnableCommandModelCache(false);
            }
            this.sessionCache = AsadminSecurityUtil.getGfClientSessionFile((String)host, (int)port);
            this.statusPrinter = new ProgressStatusPrinter(RemoteCLICommand.this.env.debug() || RemoteCLICommand.this.env.trace() || System.console() == null, RemoteCLICommand.this.env.debug() || RemoteCLICommand.this.env.trace(), logger);
            if (!RemoteCLICommand.this.programOpts.isTerse()) {
                super.registerListener("ProgressStatus/change", (AdminCommandEventBroker.AdminCommandListener)this.statusPrinter);
                super.registerListener("ProgressStatus/state", (AdminCommandEventBroker.AdminCommandListener)this.statusPrinter);
                super.registerListener("usermessage", (AdminCommandEventBroker.AdminCommandListener)this.statusPrinter);
            }
            if (StringUtils.ok((String)(stimeout = RemoteCLICommand.this.env.getStringOption("READTIMEOUT")))) {
                super.setReadTimeout(Integer.parseInt(stimeout));
            }
        }

        public void fetchCommandModel() throws CommandException {
            super.fetchCommandModel();
        }

        protected boolean updateAuthentication() {
            Console cons;
            if (RemoteCLICommand.this.programOpts.isInteractive() && (cons = System.console()) != null) {
                String puser;
                char[] password;
                ProgramOptions.PasswordLocation pwloc = RemoteCLICommand.this.programOpts.getPasswordLocation();
                if (pwloc == ProgramOptions.PasswordLocation.PASSWORD_FILE) {
                    this.logger.fine(strings.get("BadPasswordFromFile", new Object[]{RemoteCLICommand.this.programOpts.getPasswordFile()}));
                } else if (pwloc == ProgramOptions.PasswordLocation.LOGIN_FILE) {
                    try {
                        LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
                        this.logger.fine(strings.get("BadPasswordFromLogin", new Object[]{store.getName()}));
                    }
                    catch (StoreException store) {
                        // empty catch block
                    }
                }
                String user = null;
                if (RemoteCLICommand.this.programOpts.getUser() == null) {
                    cons.printf("%s ", strings.get("AdminUserPrompt"));
                    user = cons.readLine();
                    if (user == null) {
                        return false;
                    }
                }
                if ((password = RemoteCLICommand.ok(puser = RemoteCLICommand.ok(user) ? user : RemoteCLICommand.this.programOpts.getUser()) ? RemoteCLICommand.this.readPassword(strings.get("AdminUserPasswordPrompt", new Object[]{puser})) : RemoteCLICommand.this.readPassword(strings.get("AdminPasswordPrompt"))) == null) {
                    return false;
                }
                if (RemoteCLICommand.ok(user)) {
                    RemoteCLICommand.this.programOpts.setUser(user);
                    this.user = user;
                }
                RemoteCLICommand.this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.USER);
                this.password = password;
                return true;
            }
            return false;
        }

        protected String getFromEnvironment(String name) {
            String result = RemoteCLICommand.this.env.getStringOption(name);
            if (!StringUtils.ok((String)result)) {
                result = RemoteCLICommand.this.programOpts.getPlainOption(name);
            }
            return result;
        }

        protected boolean retryUsingSecureConnection(String host, int port) {
            String msg = strings.get("ServerMaybeSecure", new Object[]{host, "" + port});
            this.logger.info(msg);
            return true;
        }

        protected String reportAuthenticationException() {
            String msg = null;
            ProgramOptions.PasswordLocation pwloc = RemoteCLICommand.this.programOpts.getPasswordLocation();
            if (pwloc == ProgramOptions.PasswordLocation.PASSWORD_FILE) {
                msg = strings.get("InvalidCredentialsFromFile", new Object[]{RemoteCLICommand.this.programOpts.getUser(), RemoteCLICommand.this.programOpts.getPasswordFile()});
            } else if (pwloc == ProgramOptions.PasswordLocation.LOGIN_FILE) {
                try {
                    LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
                    msg = strings.get("InvalidCredentialsFromLogin", new Object[]{RemoteCLICommand.this.programOpts.getUser(), store.getName()});
                }
                catch (StoreException storeException) {
                    // empty catch block
                }
            }
            if (msg == null) {
                msg = strings.get("InvalidCredentials", new Object[]{RemoteCLICommand.this.programOpts.getUser()});
            }
            return msg;
        }

        protected synchronized void addAdditionalHeaders(URLConnection urlConnection) {
            this.addCookieHeaders(urlConnection);
        }

        protected boolean useSse() throws CommandException {
            if (RemoteCLICommand.this.env.getBooleanOption("NOSSE")) {
                return false;
            }
            return RemoteCLICommand.this.programOpts.isDetachedCommand() || RemoteCLICommand.this.listeners.size() > 0 || super.useSse();
        }

        protected boolean refetchInvalidModel() {
            return false;
        }

        private void addCookieHeaders(URLConnection urlConnection) {
            long modifiedTime = this.sessionCache.lastModified();
            if (modifiedTime == 0L) {
                return;
            }
            ((CookieManager)CookieHandler.getDefault()).getCookieStore().removeAll();
            this.cookieManager = new CookieManager(new ClientCookieStore(new CookieManager().getCookieStore(), this.sessionCache), CookiePolicy.ACCEPT_ALL);
            try {
                ((ClientCookieStore)this.cookieManager.getCookieStore()).load();
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Unable to load cookies: " + e.toString());
                }
                return;
            }
            if (this.isSessionCookieExpired(this.cookieManager, modifiedTime)) {
                this.logger.finer("Cookie session file has expired.");
                if (!this.sessionCache.delete()) {
                    this.logger.finer("Unable to delete session file.");
                }
                return;
            }
            StringBuilder sb = new StringBuilder("$Version=1");
            boolean hasCookies = false;
            for (HttpCookie cookie : this.cookieManager.getCookieStore().getCookies()) {
                hasCookies = true;
                sb.append("; ").append(cookie.getName()).append("=").append(cookie.getValue());
            }
            if (hasCookies) {
                urlConnection.setRequestProperty(COOKIE_HEADER, sb.toString());
            }
        }

        private boolean isSessionCookieExpired(CookieManager manager, long creationTime) {
            for (URI uri : manager.getCookieStore().getURIs()) {
                for (HttpCookie cookie : manager.getCookieStore().get(uri)) {
                    if (!cookie.getName().equals(JSESSIONID)) continue;
                    return creationTime / 1000L + cookie.getMaxAge() < System.currentTimeMillis() / 1000L;
                }
            }
            return true;
        }

        protected synchronized void processHeaders(URLConnection urlConnection) {
            this.processCookieHeaders(urlConnection);
        }

        private void processCookieHeaders(URLConnection urlConnection) {
            block23: {
                CookieManager systemCookieManager = (CookieManager)CookieHandler.getDefault();
                if (systemCookieManager == null) {
                    this.logger.finer("Assertion failed: null system CookieManager");
                    return;
                }
                CookieStore systemCookieJar = systemCookieManager.getCookieStore();
                List<HttpCookie> newCookies = systemCookieJar.getCookies();
                if (newCookies.isEmpty()) {
                    return;
                }
                if (this.sessionCache.lastModified() == 0L) {
                    block22: {
                        if (this.cookieManager == null) {
                            this.cookieManager = new CookieManager(new ClientCookieStore(new CookieManager().getCookieStore(), this.sessionCache), CookiePolicy.ACCEPT_ALL);
                        }
                        try {
                            this.cookieManager.put(((ClientCookieStore)this.cookieManager.getCookieStore()).getStaticURI(), urlConnection.getHeaderFields());
                        }
                        catch (IOException e) {
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Unable to save cookies: " + e.toString());
                            }
                            return;
                        }
                        try {
                            ((ClientCookieStore)this.cookieManager.getCookieStore()).store();
                        }
                        catch (IOException e) {
                            if (!this.logger.isLoggable(Level.FINER)) break block22;
                            this.logger.finer("Unable to store cookies: " + e.toString());
                        }
                    }
                    return;
                }
                if (this.cookieManager == null) {
                    this.cookieManager = new CookieManager(new ClientCookieStore(new CookieManager().getCookieStore(), this.sessionCache), CookiePolicy.ACCEPT_ALL);
                    try {
                        ((ClientCookieStore)this.cookieManager.getCookieStore()).load();
                    }
                    catch (IOException e) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Unable to load cookies: " + e.toString());
                        }
                        return;
                    }
                }
                boolean newCookieFound = false;
                for (HttpCookie cookie : systemCookieJar.getCookies()) {
                    int cookieIndex = this.cookieManager.getCookieStore().getCookies().indexOf(cookie);
                    if (cookieIndex == -1) {
                        newCookieFound = true;
                        break;
                    }
                    HttpCookie c1 = this.cookieManager.getCookieStore().getCookies().get(cookieIndex);
                    if (c1.getValue().equals(cookie.getValue())) continue;
                    newCookieFound = true;
                    break;
                }
                if (newCookieFound) {
                    try {
                        try {
                            this.cookieManager.put(((ClientCookieStore)this.cookieManager.getCookieStore()).getStaticURI(), urlConnection.getHeaderFields());
                        }
                        catch (IOException e) {
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Unable to save cookies: " + e.toString());
                            }
                            return;
                        }
                        ((ClientCookieStore)this.cookieManager.getCookieStore()).store();
                    }
                    catch (IOException e) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Unable to store cookies: " + e.toString());
                        }
                        break block23;
                    }
                }
                ((ClientCookieStore)this.cookieManager.getCookieStore()).touchStore();
            }
        }
    }
}

