/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.remote.reader.ProprietaryReaderFactory;
import com.sun.enterprise.admin.remote.writer.ProprietaryWriterFactory;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.JDK;
import java.io.File;
import java.io.PrintStream;
import java.net.ConnectException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.AsadminInput;
import org.glassfish.main.jul.GlassFishLogManager;
import org.glassfish.main.jul.GlassFishLogManagerInitializer;
import org.glassfish.main.jul.cfg.GlassFishLogManagerConfiguration;
import org.glassfish.main.jul.cfg.LoggingProperties;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class AdminMain {
    private static final LoggingProperties LOGGING_CFG;
    private static final Environment env;
    private static final int SUCCESS = 0;
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int WARNING = 4;
    private static final String ADMIN_CLI_LOGGER = "com.sun.enterprise.admin.cli";
    private static final String[] SYS_PROPERTIES_TO_SET_FROM_ASENV;
    private static final LocalStringsImpl strings;
    private String classPath;
    private String className;
    private String command;
    private ProgramOptions po;
    private CLIContainer cliContainer;
    private Logger logger;

    private ClassLoader getExtensionClassLoader(Set<File> extensions) {
        ClassLoader ecl = AdminMain.class.getClassLoader();
        if (extensions == null || extensions.isEmpty()) {
            return ecl;
        }
        PrivilegedAction<ClassLoader> action = () -> {
            try {
                return new DirectoryClassLoader(extensions, ecl);
            }
            catch (RuntimeException ex) {
                this.logger.info(strings.get("ExtDirFailed", new Object[]{ex}));
                return ecl;
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected Set<File> getExtensions() {
        HashSet<File> result = new HashSet<File>();
        File inst = new File(System.getProperty("com.sun.aas.installRoot"));
        File ext = new File(new File(inst, "lib"), "asadmin");
        if (ext.exists() && ext.isDirectory()) {
            result.add(ext);
        } else if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(strings.get("ExtDirMissing", new Object[]{ext}));
        }
        result.add(new File(new File(inst, "modules"), "admin-cli.jar"));
        return result;
    }

    protected String getCommandName() {
        return "nadmin";
    }

    public static void main(String[] args) {
        AdminMain adminMain = new AdminMain();
        int code = adminMain.doMain(args);
        System.exit(code);
    }

    protected int doMain(String[] args) {
        int minor = JDK.getMinor();
        int major = JDK.getMajor();
        if (major < 11) {
            System.err.println(strings.get("OldJdk", new Object[]{major, minor}));
            return 1;
        }
        System.setProperty("WALL_CLOCK_START", Instant.now().toString());
        GlassFishLogManager.getLogManager().reconfigure(new GlassFishLogManagerConfiguration(LOGGING_CFG), this::reconfigureLogging, null);
        Set<File> extensions = this.getExtensions();
        ClassLoader ecl = this.getExtensionClassLoader(extensions);
        Thread.currentThread().setContextClassLoader(ecl);
        Thread thread = new Thread(() -> {
            ProprietaryReaderFactory.getReader(Class.class, (String)"not/defined");
            ProprietaryWriterFactory.getWriter(Class.class);
        });
        thread.setDaemon(true);
        thread.start();
        this.cliContainer = new CLIContainer(ecl, extensions, this.logger);
        this.classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        this.className = AdminMain.class.getName();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Classpath: {0}\nArguments: {1}", new Object[]{this.classPath, Arrays.toString(args)});
        }
        if (args.length == 0) {
            args = new String[]{"multimode"};
        } else if (args[0].equals("-V")) {
            args = new String[]{"version"};
        }
        this.command = args[0];
        int exitCode = this.executeCommand(args);
        switch (exitCode) {
            case 0: {
                if (this.po.isTerse() || !this.logger.isLoggable(Level.FINE)) break;
                String key = this.po.isDetachedCommand() ? "CommandSuccessfulStarted" : "CommandSuccessful";
                this.logger.fine(strings.get(key, new Object[]{this.command}));
                break;
            }
            case 4: {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(strings.get("CommandSuccessfulWithWarnings", new Object[]{this.command}));
                }
                exitCode = 0;
                break;
            }
            default: {
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine(strings.get("CommandUnSuccessful", new Object[]{this.command}));
            }
        }
        CLIUtil.writeCommandToDebugLog(this.getCommandName(), env, args, exitCode);
        return exitCode;
    }

    public int executeCommand(String[] argv) {
        CLICommand cmd = null;
        try {
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                ParameterMap params = rcp.getOptions();
                this.po = new ProgramOptions(params, env);
                AdminMain.readAndMergeOptionsFromAuxInput(this.po);
                List<String> operands = rcp.getOperands();
                argv = operands.toArray(new String[operands.size()]);
            } else {
                this.po = new ProgramOptions(env);
            }
            this.po.toEnvironment(env);
            this.po.setClassPath(this.classPath);
            this.po.setClassName(this.className);
            this.po.setCommandName(this.getCommandName());
            if (argv.length == 0) {
                argv = this.po.isHelp() ? new String[]{"help"} : new String[]{"multimode"};
            }
            this.command = argv[0];
            this.cliContainer.setEnvironment(env);
            this.cliContainer.setProgramOptions(this.po);
            cmd = CLICommand.getCommand(this.cliContainer, this.command);
            return cmd.execute(argv);
        }
        catch (CommandValidationException cve) {
            this.logger.severe(cve.getMessage());
            if (cmd == null) {
                this.printUsage();
            } else {
                this.logger.severe(cmd.getUsage());
            }
            return 1;
        }
        catch (InvalidCommandException ice) {
            this.logger.severe(ice.getMessage());
            try {
                this.po.setEcho(false);
                CLIUtil.displayClosestMatch(this.command, CLIUtil.getAllCommands(this.cliContainer, this.po, env), strings.get("ClosestMatchedLocalAndRemoteCommands"), this.logger);
            }
            catch (InvalidCommandException params) {
                // empty catch block
            }
            return 1;
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof ConnectException) {
                this.logger.severe(ce.getMessage());
                try {
                    CLIUtil.displayClosestMatch(this.command, CLIUtil.getLocalCommands(this.cliContainer), strings.get("ClosestMatchedLocalCommands"), this.logger);
                }
                catch (InvalidCommandException e) {
                    this.logger.info(strings.get("InvalidRemoteCommand", new Object[]{this.command}));
                }
            } else {
                this.logger.severe(ce.getMessage());
            }
            return 1;
        }
    }

    private void reconfigureLogging() {
        GlassFishLoggingTracer.trace(AdminMain.class, (String)"Configuring logging for asadmin.");
        boolean trace = env.trace();
        boolean debug = env.debug();
        this.logger = Logger.getLogger(ADMIN_CLI_LOGGER);
        if (trace) {
            this.logger.setLevel(Level.FINEST);
        } else if (debug) {
            this.logger.setLevel(Level.FINER);
        } else {
            this.logger.setLevel(Level.FINE);
        }
        this.logger.setUseParentHandlers(false);
        Formatter formatter = env.getLogFormatter();
        CLILoggerHandler cliHandler = new CLILoggerHandler(formatter == null ? new CLILoggerFormatter() : formatter);
        cliHandler.setLevel(this.logger.getLevel());
        this.logger.addHandler(cliHandler);
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setUseParentHandlers(false);
        if (trace) {
            rootLogger.setLevel(this.logger.getLevel());
        }
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
            handler.close();
        }
        rootLogger.addHandler(cliHandler);
    }

    private static void readAndMergeOptionsFromAuxInput(ProgramOptions progOpts) {
        String auxInput = progOpts.getAuxInput();
        if (auxInput == null || auxInput.isEmpty()) {
            return;
        }
        progOpts.setAuxInput(null);
        ParameterMap newParamMap = new ParameterMap();
        try {
            AsadminInput.InputReader reader = AsadminInput.reader((String)auxInput);
            Properties newOptions = (Properties)reader.settings().get("option");
            for (String propName : newOptions.stringPropertyNames()) {
                newParamMap.add((Object)propName, (Object)newOptions.getProperty(propName));
            }
            progOpts.updateOptions(newParamMap);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private void printUsage() {
        this.logger.severe(strings.get("Usage.full", new Object[]{this.getCommandName()}));
    }

    private static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    static {
        GlassFishLoggingTracer.trace(AdminMain.class, (String)"Preconfiguring logging for asadmin.");
        LOGGING_CFG = new LoggingProperties();
        LOGGING_CFG.setProperty("handlers", "org.glassfish.main.jul.handler.BlockingExternallyManagedLogHandler");
        if (!GlassFishLogManagerInitializer.tryToSetAsDefault((Properties)LOGGING_CFG)) {
            throw new IllegalStateException("GlassFishLogManager is not set as the default LogManager!");
        }
        env = new Environment();
        SYS_PROPERTIES_TO_SET_FROM_ASENV = new String[]{"com.sun.aas.installRoot", "com.sun.aas.configRoot", "com.sun.aas.productRoot"};
        strings = new LocalStringsImpl(AdminMain.class);
        Map systemProps = new ASenvPropertyReader().getProps();
        for (String prop : SYS_PROPERTIES_TO_SET_FROM_ASENV) {
            String val = (String)systemProps.get(prop);
            if (!AdminMain.isNotEmpty(val)) continue;
            System.setProperty(prop, val);
        }
    }

    private static class CLILoggerHandler
    extends ConsoleHandler {
        private CLILoggerHandler(Formatter formatter) {
            this.setFormatter(formatter);
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            PrintStream ps = logRecord.getLevel() == Level.SEVERE ? System.err : System.out;
            ps.print(this.getFormatter().format(logRecord));
            ps.flush();
        }
    }

    private static class CLILoggerFormatter
    extends SimpleFormatter {
        private static final boolean TRACE = env.trace();

        private CLILoggerFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            Object[] parameters;
            if (record.getThrown() == null) {
                return this.formatMessage(record) + System.lineSeparator();
            }
            if (record.getParameters() == null) {
                parameters = new Object[]{record.getThrown()};
            } else {
                parameters = new Object[record.getParameters().length + 1];
                System.arraycopy(record.getParameters(), 0, parameters, 0, parameters.length - 1);
                parameters[parameters.length - 1] = record.getThrown();
            }
            record.setParameters(parameters);
            if (TRACE) {
                return super.format(record) + System.lineSeparator();
            }
            return this.formatMessage(record) + " " + record.getThrown().getLocalizedMessage() + System.lineSeparator();
        }
    }
}

