/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.progress;

import com.sun.enterprise.admin.progress.CommandProgressImpl;
import com.sun.enterprise.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.progress.ProgressStatusBase;
import org.glassfish.api.admin.progress.ProgressStatusDTO;
import org.glassfish.api.admin.progress.ProgressStatusEvent;

public class ProgressStatusClient {
    private ProgressStatus status;
    private final Map<String, ProgressStatus> map = new HashMap<String, ProgressStatus>();

    public ProgressStatusClient(ProgressStatus status) {
        this.status = status;
    }

    private synchronized void preventNullStatus(String name, String id) {
        if (this.status == null) {
            this.status = new CommandProgressImpl(name, id);
        }
        this.map.put(id, this.status);
    }

    public synchronized void mirror(ProgressStatusDTO dto) {
        if (dto == null) {
            return;
        }
        this.preventNullStatus(dto.getName(), dto.getId());
        this.mirror(dto, this.status);
    }

    private void mirror(ProgressStatusDTO dto, ProgressStatus stat) {
        stat.setTotalStepCount(dto.getTotalStepCount());
        stat.setCurrentStepCount(dto.getCurrentStepCount());
        if (dto.isCompleted()) {
            stat.complete();
        }
        for (ProgressStatusDTO.ChildProgressStatusDTO chld : dto.getChildren()) {
            ProgressStatus dst = this.map.get(chld.getProgressStatus().getId());
            if (dst == null) {
                dst = stat.createChild(chld.getProgressStatus().getName(), chld.getAllocatedSteps());
                this.map.put(chld.getProgressStatus().getId(), dst);
            }
            this.mirror(chld.getProgressStatus(), dst);
        }
    }

    public synchronized void mirror(ProgressStatusBase source) {
        if (source == null) {
            return;
        }
        this.preventNullStatus(source.getName(), source.getId());
        this.mirror(source, this.status);
    }

    private void mirror(ProgressStatusBase source, ProgressStatus stat) {
        stat.setTotalStepCount(source.getTotalStepCount());
        stat.setCurrentStepCount(source.getCurrentStepCount());
        if (source.isComplete()) {
            stat.complete();
        }
        for (ProgressStatusBase.ChildProgressStatus chld : source.getChildProgressStatuses()) {
            ProgressStatus dst = this.map.get(chld.getProgressStatus().getId());
            if (dst == null) {
                dst = stat.createChild(chld.getProgressStatus().getName(), chld.getAllocatedSteps());
                this.map.put(chld.getProgressStatus().getId(), dst);
            }
            this.mirror(chld.getProgressStatus(), dst);
        }
    }

    public synchronized void mirror(ProgressStatusEvent event) {
        if (event == null) {
            return;
        }
        ProgressStatus effected = this.map.get(event.getSource().getId());
        boolean msgChanged = false;
        if (event.getChanged() != null && event.getChanged().size() > 0) {
            block7: for (ProgressStatusEvent.Changed chng : event.getChanged()) {
                switch (chng) {
                    case NEW_CHILD: {
                        effected = this.map.get(event.getParentSourceId());
                        if (effected == null) continue block7;
                        ProgressStatus child = effected.createChild(event.getSource().getName(), event.getAllocatedSteps());
                        this.map.put(event.getSource().getId(), child);
                        child.setTotalStepCount(event.getSource().getTotalStepCount());
                        child.setCurrentStepCount(event.getSource().getCurrentStepCount());
                        if (!event.getSource().isCompleted()) continue block7;
                        child.complete();
                        break;
                    }
                    case COMPLETED: {
                        effected.complete(event.getMessage());
                        msgChanged = true;
                        break;
                    }
                    case STEPS: {
                        effected.setCurrentStepCount(event.getSource().getCurrentStepCount());
                        if (!StringUtils.ok((String)event.getMessage())) continue block7;
                        effected.progress(0, event.getMessage(), event.isSpinner());
                        msgChanged = true;
                        break;
                    }
                    case TOTAL_STEPS: {
                        effected.setTotalStepCount(event.getSource().getTotalStepCount());
                        if (!StringUtils.ok((String)event.getMessage())) continue block7;
                        effected.progress(0, event.getMessage(), event.isSpinner());
                        msgChanged = true;
                        break;
                    }
                    case SPINNER: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        if (!msgChanged && StringUtils.ok((String)event.getMessage())) {
            effected.progress(0, event.getMessage(), event.isSpinner());
        }
    }

    public synchronized ProgressStatus getProgressStatus() {
        return this.status;
    }
}

