/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminInternalUser;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Invocation;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.security.common.MasterPassword;

public class ServerRemoteRestAdminCommand
extends RemoteRestAdminCommand {
    private static final String SSL_SOCKET_PROTOCOL = "TLS";
    private ServiceLocator habitat;
    private SecureAdmin secureAdmin;
    private ServerEnvironment serverEnv;
    private SSLUtils _sslUtils = null;
    private MasterPassword masterPasswordHelper = null;

    public ServerRemoteRestAdminCommand(ServiceLocator habitat, String name, String host, int port, boolean secure, String user, String password, Logger logger) throws CommandException {
        super(name, host, port, secure, "admin", "", logger);
        super.setOmitCache(true);
        this.completeInit(habitat);
    }

    private synchronized void completeInit(ServiceLocator habitat) {
        this.habitat = habitat;
        Domain domain = (Domain)habitat.getService(Domain.class, new Annotation[0]);
        this.secureAdmin = domain.getSecureAdmin();
        this.serverEnv = (ServerEnvironment)habitat.getService(ServerEnvironment.class, new Annotation[0]);
        this.secure = SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin);
        this.setInteractive(false);
    }

    @Override
    protected synchronized SSLContext getSslContext() {
        try {
            String certAlias = SecureAdmin.Util.isUsingUsernamePasswordAuth((SecureAdmin)this.secureAdmin) ? null : this.getCertAlias();
            return this.sslUtils().getAdminSSLContext(certAlias, SSL_SOCKET_PROTOCOL);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected synchronized AuthenticationInfo authenticationInfo() {
        SecureAdminInternalUser secureAdminInternalUser;
        AuthenticationInfo result = null;
        if (SecureAdmin.Util.isUsingUsernamePasswordAuth((SecureAdmin)this.secureAdmin) && (secureAdminInternalUser = SecureAdmin.Util.secureAdminInternalUser((SecureAdmin)this.secureAdmin)) != null) {
            try {
                result = new AuthenticationInfo(secureAdminInternalUser.getUsername(), this.masterPassword().getMasterPasswordAdapter().getPasswordForAlias(secureAdminInternalUser.getPasswordAlias()));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    @Override
    protected synchronized Invocation.Builder addAdditionalHeaders(Invocation.Builder request) {
        String indicatorValue = SecureAdmin.Util.configuredAdminIndicator((SecureAdmin)this.secureAdmin);
        if (indicatorValue != null) {
            return request.header("X-GlassFish-admin", (Object)indicatorValue);
        }
        return request;
    }

    private synchronized String getCertAlias() {
        return this.serverEnv.isDas() ? SecureAdmin.Util.DASAlias((SecureAdmin)this.secureAdmin) : SecureAdmin.Util.instanceAlias((SecureAdmin)this.secureAdmin);
    }

    private synchronized SSLUtils sslUtils() {
        if (this._sslUtils == null) {
            this._sslUtils = (SSLUtils)this.habitat.getService(SSLUtils.class, new Annotation[0]);
        }
        return this._sslUtils;
    }

    private synchronized MasterPassword masterPassword() {
        if (this.masterPasswordHelper == null) {
            this.masterPasswordHelper = (MasterPassword)this.habitat.getService(MasterPassword.class, new Annotation[0]);
        }
        return this.masterPasswordHelper;
    }
}

